/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.clustering.clusterer;

import com.rapidminer.operator.clustering.HierarchicalClusterNode;
import com.rapidminer.operator.clustering.clusterer.AbstractLinkageMethod;
import com.rapidminer.operator.clustering.clusterer.DistanceMatrix;
import java.util.Map;

public class AverageLinkageMethod
extends AbstractLinkageMethod {
    private int[] clusterIds;

    public AverageLinkageMethod(DistanceMatrix matrix, int[] clusterIds) {
        super(matrix, clusterIds);
        this.clusterIds = clusterIds;
    }

    @Override
    public void updateDistances(DistanceMatrix matrix, int updatedRow, int unionedRow, Map<Integer, HierarchicalClusterNode> clusterMap) {
        double weightUpdatedRow = clusterMap.get(this.clusterIds[updatedRow]).getNumberOfExamplesInSubtree();
        double weightUnionedRow = clusterMap.get(this.clusterIds[unionedRow]).getNumberOfExamplesInSubtree();
        double totalWeight = weightUnionedRow + weightUpdatedRow;
        weightUnionedRow /= totalWeight;
        weightUpdatedRow /= totalWeight;
        for (int y = 0; y < matrix.getHeight(); ++y) {
            matrix.set(updatedRow, y, weightUpdatedRow * matrix.get(updatedRow, y) + weightUnionedRow * matrix.get(unionedRow, y));
        }
    }
}

