/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.clustering.clusterer;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.gui.ExampleVisualizer;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.clustering.DendogramHierarchicalClusterModel;
import com.rapidminer.operator.clustering.HierarchicalClusterLeafNode;
import com.rapidminer.operator.clustering.HierarchicalClusterModel;
import com.rapidminer.operator.clustering.HierarchicalClusterNode;
import com.rapidminer.operator.clustering.clusterer.AbstractLinkageMethod;
import com.rapidminer.operator.clustering.clusterer.Agglomeration;
import com.rapidminer.operator.clustering.clusterer.AverageLinkageMethod;
import com.rapidminer.operator.clustering.clusterer.CompleteLinkageMethod;
import com.rapidminer.operator.clustering.clusterer.DistanceMatrix;
import com.rapidminer.operator.clustering.clusterer.SingleLinkageMethod;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.DistanceMeasurePrecondition;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetPassThroughRule;
import com.rapidminer.operator.ports.metadata.GenerateNewMDRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeStringCategory;
import com.rapidminer.tools.ObjectVisualizerService;
import com.rapidminer.tools.math.similarity.DistanceMeasure;
import com.rapidminer.tools.math.similarity.DistanceMeasureHelper;
import com.rapidminer.tools.math.similarity.DistanceMeasures;
import java.util.HashMap;
import java.util.List;

public class AgglomerativeClustering
extends Operator {
    private InputPort exampleSetInput = this.getInputPorts().createPort("example set", new ExampleSetMetaData());
    private OutputPort modelOutput = (OutputPort)this.getOutputPorts().createPort("cluster model");
    private OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set");
    private DistanceMeasureHelper measureHelper = new DistanceMeasureHelper(this);
    public static final String PARAMETER_MODE = "mode";
    public static final String[] modes = new String[]{"SingleLink", "CompleteLink", "AverageLink"};

    public AgglomerativeClustering(OperatorDescription description) {
        super(description);
        this.exampleSetInput.addPrecondition(new DistanceMeasurePrecondition(this.exampleSetInput, this));
        this.getTransformer().addRule(new GenerateNewMDRule(this.modelOutput, new MetaData(HierarchicalClusterModel.class)));
        this.getTransformer().addRule(new ExampleSetPassThroughRule(this.exampleSetInput, this.exampleSetOutput, SetRelation.EQUAL){

            @Override
            public ExampleSetMetaData modifyExampleSet(ExampleSetMetaData metaData) {
                metaData.addAttribute(new AttributeMetaData("id", 3, "id"));
                return metaData;
            }
        });
    }

    @Override
    public void doWork() throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)this.exampleSetInput.getData();
        DistanceMeasure measure = this.measureHelper.getInitializedMeasure(exampleSet);
        Tools.onlyNonMissingValues(exampleSet, "AgglomerativeClustering");
        Tools.checkAndCreateIds(exampleSet);
        Attribute idAttribute = exampleSet.getAttributes().getId();
        boolean idAttributeIsNominal = idAttribute.isNominal();
        DistanceMatrix matrix = new DistanceMatrix(exampleSet.size());
        HashMap<Integer, HierarchicalClusterNode> clusterMap = new HashMap<Integer, HierarchicalClusterNode>(exampleSet.size());
        int[] clusterIds = new int[exampleSet.size()];
        int nextClusterId = 0;
        for (Example example1 : exampleSet) {
            this.checkForStop();
            clusterIds[nextClusterId] = nextClusterId;
            int y = 0;
            for (Example example2 : exampleSet) {
                if (y > nextClusterId) {
                    matrix.set(nextClusterId, y, measure.calculateDistance(example1, example2));
                }
                ++y;
            }
            if (idAttributeIsNominal) {
                clusterMap.put(nextClusterId, new HierarchicalClusterLeafNode(nextClusterId, example1.getValueAsString(idAttribute)));
            } else {
                clusterMap.put(nextClusterId, new HierarchicalClusterLeafNode(nextClusterId, (Object)example1.getValue(idAttribute)));
            }
            ++nextClusterId;
        }
        AbstractLinkageMethod linkage = new SingleLinkageMethod(matrix, clusterIds);
        if (this.getParameterAsString(PARAMETER_MODE).equals(modes[1])) {
            linkage = new CompleteLinkageMethod(matrix, clusterIds);
        } else if (this.getParameterAsString(PARAMETER_MODE).equals(modes[2])) {
            linkage = new AverageLinkageMethod(matrix, clusterIds);
        }
        while (clusterMap.size() > 1) {
            Agglomeration agglomeration = linkage.getNextAgglomeration(nextClusterId, clusterMap);
            HierarchicalClusterNode newNode = new HierarchicalClusterNode(nextClusterId, agglomeration.getDistance());
            newNode.addSubNode((HierarchicalClusterNode)clusterMap.get(agglomeration.getClusterId1()));
            newNode.addSubNode((HierarchicalClusterNode)clusterMap.get(agglomeration.getClusterId2()));
            clusterMap.remove(agglomeration.getClusterId1());
            clusterMap.remove(agglomeration.getClusterId2());
            clusterMap.put(nextClusterId, newNode);
            ++nextClusterId;
        }
        DendogramHierarchicalClusterModel model = new DendogramHierarchicalClusterModel((HierarchicalClusterNode)clusterMap.entrySet().iterator().next().getValue());
        ObjectVisualizerService.addObjectVisualizer(model, new ExampleVisualizer((ExampleSet)exampleSet.clone()));
        this.modelOutput.deliver(model);
        this.exampleSetOutput.deliver(exampleSet);
    }

    @Override
    public boolean shouldAutoConnect(OutputPort port) {
        if (port == this.exampleSetOutput) {
            return this.getParameterAsBoolean("keep_example_set");
        }
        return super.shouldAutoConnect(port);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeStringCategory type = new ParameterTypeStringCategory(PARAMETER_MODE, "Specifies the cluster mode.", modes, modes[0], false);
        type.setExpert(false);
        types.add(type);
        types.addAll(DistanceMeasures.getParameterTypes(this));
        return types;
    }
}

