/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.clustering.clusterer;

import com.rapidminer.operator.clustering.HierarchicalClusterNode;
import com.rapidminer.operator.clustering.clusterer.Agglomeration;
import com.rapidminer.operator.clustering.clusterer.DistanceMatrix;
import java.util.Map;

public abstract class AbstractLinkageMethod {
    private DistanceMatrix matrix;
    private boolean[] isDeletedData;
    private int[] clusterIds;

    public AbstractLinkageMethod(DistanceMatrix matrix, int[] clusterIds) {
        this.matrix = matrix;
        this.clusterIds = clusterIds;
        this.isDeletedData = new boolean[matrix.getHeight()];
    }

    public Agglomeration getNextAgglomeration(int nextClusterId, Map<Integer, HierarchicalClusterNode> clusterMap) {
        double minimalDistance = Double.POSITIVE_INFINITY;
        int minimalX = -1;
        int minimalY = -1;
        for (int x = 0; x < this.matrix.getWidth(); ++x) {
            if (this.isDeletedData[x]) continue;
            for (int y = x + 1; y < this.matrix.getHeight(); ++y) {
                double value;
                if (this.isDeletedData[y] || !((value = this.matrix.get(x, y)) <= minimalDistance)) continue;
                minimalX = x;
                minimalY = y;
                minimalDistance = value;
            }
        }
        Agglomeration agglomeration = new Agglomeration(this.clusterIds[minimalX], this.clusterIds[minimalY], minimalDistance);
        this.updateDistances(this.matrix, minimalX, minimalY, clusterMap);
        this.isDeletedData[minimalY] = true;
        this.clusterIds[minimalX] = nextClusterId;
        return agglomeration;
    }

    public abstract void updateDistances(DistanceMatrix var1, int var2, int var3, Map<Integer, HierarchicalClusterNode> var4);
}

