/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.clustering.clusterer;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.gui.ExampleVisualizer;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.clustering.ClusterModel;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetPassThroughRule;
import com.rapidminer.operator.ports.metadata.GenerateNewMDRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.operator.ports.metadata.SimplePrecondition;
import com.rapidminer.tools.ObjectVisualizerService;
import com.rapidminer.tools.metadata.MetaDataTools;
import java.util.Collection;
import java.util.LinkedList;

public abstract class AbstractClusterer
extends Operator {
    private InputPort exampleSetInput = (InputPort)this.getInputPorts().createPort("example set");
    private OutputPort modelOutput = (OutputPort)this.getOutputPorts().createPort("cluster model");
    private OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("clustered set");

    public AbstractClusterer(OperatorDescription description) {
        super(description);
        this.exampleSetInput.addPrecondition(new SimplePrecondition(this.exampleSetInput, new ExampleSetMetaData()));
        this.getTransformer().addRule(new GenerateNewMDRule(this.modelOutput, new MetaData(this.getClusterModelClass())));
        this.getTransformer().addRule(new ExampleSetPassThroughRule(this.exampleSetInput, this.exampleSetOutput, SetRelation.EQUAL){

            @Override
            public ExampleSetMetaData modifyExampleSet(ExampleSetMetaData metaData) {
                if (AbstractClusterer.this.addsClusterAttribute()) {
                    if (AbstractClusterer.this.addsClusterAttribute()) {
                        metaData.addAttribute(new AttributeMetaData("cluster", 1, "cluster"));
                    }
                    if (AbstractClusterer.this.addsIdAttribute()) {
                        MetaDataTools.checkAndCreateIds(metaData);
                    }
                    metaData.addAllAttributes(AbstractClusterer.this.getAdditionalAttributes());
                }
                return metaData;
            }
        });
    }

    public abstract ClusterModel generateClusterModel(ExampleSet var1) throws OperatorException;

    protected abstract boolean addsClusterAttribute();

    protected abstract boolean addsIdAttribute();

    protected Collection<AttributeMetaData> getAdditionalAttributes() {
        return new LinkedList<AttributeMetaData>();
    }

    @Override
    public void doWork() throws OperatorException {
        ExampleSet input = (ExampleSet)this.exampleSetInput.getData();
        ClusterModel clusterModel = this.generateClusterModel(input);
        ObjectVisualizerService.addObjectVisualizer(clusterModel, new ExampleVisualizer((ExampleSet)input.clone()));
        this.modelOutput.deliver(clusterModel);
        this.exampleSetOutput.deliver(input);
    }

    public Class<? extends ClusterModel> getClusterModelClass() {
        return ClusterModel.class;
    }

    @Override
    public boolean shouldAutoConnect(OutputPort outputPort) {
        if (outputPort == this.exampleSetOutput) {
            return this.addsClusterAttribute();
        }
        return super.shouldAutoConnect(outputPort);
    }

    public InputPort getExampleSetInputPort() {
        return this.exampleSetInput;
    }
}

