/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.clustering;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;

public class HierarchicalClusterNode
implements Serializable {
    private static final long serialVersionUID = 2249266864895013348L;
    private Collection<HierarchicalClusterNode> subNodes;
    private double distance;
    private String clusterId;

    public HierarchicalClusterNode(String clusterId) {
        this.clusterId = clusterId;
        this.subNodes = new ArrayList<HierarchicalClusterNode>();
    }

    public HierarchicalClusterNode(int clusterId, double distance) {
        this(clusterId + "");
        this.distance = distance;
    }

    public HierarchicalClusterNode(String clusterId, double distance) {
        this(clusterId);
        this.distance = distance;
    }

    public Collection<HierarchicalClusterNode> getSubNodes() {
        return this.subNodes;
    }

    public int getNumberOfSubNodes() {
        return this.subNodes.size();
    }

    public double getDistance() {
        return this.distance;
    }

    public Collection<Object> getExampleIdsInSubtree() {
        LinkedList<Object> examples = new LinkedList<Object>();
        for (HierarchicalClusterNode subNode : this.subNodes) {
            examples.addAll(subNode.getExampleIdsInSubtree());
        }
        return examples;
    }

    public int getNumberOfExamplesInSubtree() {
        int subtreeSum = 0;
        for (HierarchicalClusterNode subNode : this.subNodes) {
            subtreeSum += subNode.getNumberOfExamplesInSubtree();
        }
        return subtreeSum;
    }

    public void addSubNode(HierarchicalClusterNode node) {
        this.subNodes.add(node);
    }

    public int getTotalNumberOfSubnodes() {
        if (this.getNumberOfSubNodes() == 0) {
            return 1;
        }
        int count = 0;
        for (HierarchicalClusterNode child : this.getSubNodes()) {
            count += child.getTotalNumberOfSubnodes();
        }
        return ++count;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String toString() {
        return this.clusterId + ":" + this.getNumberOfExamplesInSubtree() + " (" + this.getDistance() + ")";
    }
}

