/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.clustering;

import com.rapidminer.operator.ResultObjectAdapter;
import com.rapidminer.operator.clustering.Cluster;
import com.rapidminer.operator.clustering.ClusterModel;
import com.rapidminer.operator.clustering.ClusterModelInterface;
import com.rapidminer.operator.clustering.HierarchicalClusterLeafNode;
import com.rapidminer.operator.clustering.HierarchicalClusterNode;
import com.rapidminer.tools.Tools;

public class HierarchicalClusterModel
extends ResultObjectAdapter
implements ClusterModelInterface {
    private static final long serialVersionUID = 75808296412095255L;
    private HierarchicalClusterNode rootNode;

    public HierarchicalClusterModel(ClusterModel clusterModel) {
        this.rootNode = new HierarchicalClusterNode("root");
        for (Cluster cluster : clusterModel.getClusters()) {
            this.rootNode.addSubNode(new HierarchicalClusterLeafNode(cluster.getClusterId(), cluster.getExampleIds()));
        }
    }

    public HierarchicalClusterModel(HierarchicalClusterNode root) {
        this.rootNode = root;
    }

    public HierarchicalClusterNode getRootNode() {
        return this.rootNode;
    }

    public String getExtension() {
        return "hcm";
    }

    public String getFileDescription() {
        return "Hierarchical Cluster Model";
    }

    @Override
    public String getName() {
        return "Hierarchical Cluster Model";
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("Number of clusters :" + this.rootNode.getTotalNumberOfSubnodes() + Tools.getLineSeparator());
        result.append("Number of items :" + this.rootNode.getNumberOfExamplesInSubtree());
        return result.toString();
    }
}

