/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.clustering;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.clustering.Cluster;
import com.rapidminer.operator.clustering.ClusterModel;
import com.rapidminer.operator.clustering.HierarchicalClusterModel;
import com.rapidminer.operator.clustering.HierarchicalClusterNode;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.GenerateNewMDRule;
import com.rapidminer.operator.ports.metadata.PassThroughRule;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;

public class FlattenClusterModel
extends Operator {
    public static final String PARAMETER_NUMBER_OF_CLUSTER = "number_of_clusters";
    public static final String PARAMETER_REMOVE_UNLABELED = "remove_unlabeled";
    public static final String PARAMETER_ADD_AS_LABEL = "add_as_label";
    private InputPort hierarchicalInput = this.getInputPorts().createPort("hierarchical", HierarchicalClusterModel.class);
    private InputPort exampleSetInput = this.getInputPorts().createPort("example set", ExampleSet.class);
    private OutputPort flatOutput = (OutputPort)this.getOutputPorts().createPort("flat");
    private OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set");

    public FlattenClusterModel(OperatorDescription description) {
        super(description);
        this.getTransformer().addRule(new GenerateNewMDRule(this.flatOutput, ClusterModel.class));
        this.getTransformer().addRule(new PassThroughRule(this.exampleSetInput, this.exampleSetOutput, true));
    }

    @Override
    public void doWork() throws OperatorException {
        HierarchicalClusterModel hierarchicalModel = (HierarchicalClusterModel)this.hierarchicalInput.getData();
        ExampleSet exampleSet = (ExampleSet)this.exampleSetInput.getData();
        this.flatOutput.deliver(this.flatten(hierarchicalModel, exampleSet));
    }

    public ClusterModel flatten(HierarchicalClusterModel model, ExampleSet exampleSet) throws OperatorException {
        HierarchicalClusterNode root = model.getRootNode();
        int numberOfClusters = this.getParameterAsInt(PARAMETER_NUMBER_OF_CLUSTER);
        PriorityQueue<HierarchicalClusterNode> queue = new PriorityQueue<HierarchicalClusterNode>(numberOfClusters, new Comparator<HierarchicalClusterNode>(){

            @Override
            public int compare(HierarchicalClusterNode o1, HierarchicalClusterNode o2) {
                int value = -1 * Double.compare(o1.getDistance(), o2.getDistance());
                if (value != 0) {
                    return value;
                }
                return -1 * Double.compare(o1.getNumberOfExamplesInSubtree(), o2.getNumberOfExamplesInSubtree());
            }
        });
        LinkedList<HierarchicalClusterNode> leafs = new LinkedList<HierarchicalClusterNode>();
        queue.add(root);
        while (queue.size() < numberOfClusters - leafs.size()) {
            HierarchicalClusterNode topNode = queue.poll();
            if (topNode.getSubNodes().size() > 0) {
                queue.addAll(topNode.getSubNodes());
                continue;
            }
            leafs.add(topNode);
        }
        queue.addAll(leafs);
        ClusterModel flatModel = new ClusterModel(exampleSet, numberOfClusters, this.getParameterAsBoolean(PARAMETER_ADD_AS_LABEL), this.getParameterAsBoolean(PARAMETER_REMOVE_UNLABELED));
        int i = 0;
        for (HierarchicalClusterNode node : queue) {
            Cluster flatCluster = flatModel.getCluster(i);
            for (Object exampleId : node.getExampleIdsInSubtree()) {
                flatCluster.assignExample(exampleId);
            }
            ++i;
        }
        if (this.exampleSetOutput.isConnected()) {
            this.exampleSetOutput.deliver(flatModel.apply((ExampleSet)exampleSet.clone()));
        }
        return flatModel;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeInt(PARAMETER_NUMBER_OF_CLUSTER, "Specifies how many flat clusters should be created.", 1, Integer.MAX_VALUE, 3);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_ADD_AS_LABEL, "Should the cluster values be added as label.", false);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_REMOVE_UNLABELED, "Delete the unlabeled examples.", false);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

