/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.clustering;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.clustering.ClusterModel;
import com.rapidminer.tools.Tools;
import java.util.HashMap;
import java.util.Map;

public class FlatFuzzyClusterModel
extends ClusterModel {
    private static final long serialVersionUID = -1408826564261080217L;
    private final Map<Integer, Double> clusterStandardDeviations = new HashMap<Integer, Double>();
    private final Map<Integer, Double> clusterProbabilities = new HashMap<Integer, Double>();
    private final Map<Integer, double[]> clusterMeans = new HashMap<Integer, double[]>();
    private final Map<Integer, double[][]> clusterCovarianceMatrix = new HashMap<Integer, double[][]>();
    private double[][] exampleInClusterProbability;

    public FlatFuzzyClusterModel(ExampleSet exampleSet, int k, boolean addClusterAsLabel, boolean removeUnknown) {
        super(exampleSet, k, addClusterAsLabel, removeUnknown);
    }

    public double getExampleInClusterProbability(int example, int cluster) {
        return this.exampleInClusterProbability[example][cluster];
    }

    public void setExampleInClusterProbability(double[][] exampleInClusterProbability) {
        this.exampleInClusterProbability = new double[exampleInClusterProbability.length][exampleInClusterProbability[0].length];
        for (int i = 0; i < exampleInClusterProbability.length; ++i) {
            for (int j = 0; j < exampleInClusterProbability[i].length; ++j) {
                this.exampleInClusterProbability[i][j] = exampleInClusterProbability[i][j];
            }
        }
    }

    public double[] getClusterMean(int cluster) {
        return this.clusterMeans.get(cluster);
    }

    public void setClusterMean(int cluster, double[] value) {
        this.clusterMeans.put(cluster, value);
    }

    public double getClusterProbability(int cluster) {
        return this.clusterProbabilities.get(cluster);
    }

    public void setClusterProbability(int cluster, double value) {
        this.clusterProbabilities.put(cluster, value);
    }

    public double getClusterStandardDeviation(int cluster) {
        return this.clusterStandardDeviations.get(cluster);
    }

    public void setClusterStandardDeviation(int cluster, double value) {
        this.clusterStandardDeviations.put(cluster, value);
    }

    public void clearClusterStandardDeviations() {
        this.clusterStandardDeviations.clear();
    }

    public double[][] getClusterCovarianceMatrix(int cluster) {
        return this.clusterCovarianceMatrix.get(cluster);
    }

    public void setClusterCovarianceMatrix(int cluster, double[][] matrix) {
        this.clusterCovarianceMatrix.put(cluster, matrix);
    }

    @Override
    public String toString() {
        int j;
        int i;
        StringBuffer result = new StringBuffer(super.toString() + Tools.getLineSeparator());
        result.append("------------------------------------------------------" + Tools.getLineSeparators(2));
        if (!this.clusterProbabilities.isEmpty()) {
            result.append("cluster probabilities:" + Tools.getLineSeparator());
            for (i = 0; i < this.clusterProbabilities.size(); ++i) {
                result.append("Cluster " + i + ": " + this.clusterProbabilities.get(i) + Tools.getLineSeparator());
            }
            result.append(Tools.getLineSeparator());
        }
        if (!this.clusterMeans.isEmpty()) {
            result.append("cluster means:" + Tools.getLineSeparator());
            for (i = 0; i < this.clusterMeans.size(); ++i) {
                result.append("Cluster " + i + ": ");
                for (j = 0; j < this.clusterMeans.get(i).length; ++j) {
                    result.append(this.clusterMeans.get(i)[j]);
                    if (j >= this.clusterMeans.get(i).length - 1) continue;
                    result.append("; ");
                }
                result.append(Tools.getLineSeparator());
            }
            result.append(Tools.getLineSeparator());
        }
        if (!this.clusterStandardDeviations.isEmpty()) {
            result.append("cluster standard deviations:" + Tools.getLineSeparator());
            for (i = 0; i < this.clusterStandardDeviations.size(); ++i) {
                result.append("Cluster " + i + ": " + this.clusterStandardDeviations.get(i) + Tools.getLineSeparator());
            }
            result.append(Tools.getLineSeparator());
        }
        if (!this.clusterCovarianceMatrix.isEmpty()) {
            result.append("cluster covariance matrices:" + Tools.getLineSeparator());
            for (i = 0; i < this.clusterCovarianceMatrix.size(); ++i) {
                result.append("Cluster " + i + ": " + Tools.getLineSeparator());
                for (j = 0; j < this.clusterMeans.get(i).length; ++j) {
                    for (int k = 0; k < this.clusterCovarianceMatrix.get(i)[j].length; ++k) {
                        result.append(this.clusterCovarianceMatrix.get(i)[j][k] + "\t");
                    }
                    result.append(Tools.getLineSeparator());
                }
            }
            result.append(Tools.getLineSeparator());
        }
        return result.toString();
    }
}

