/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.clustering;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.example.table.NominalMapping;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.clustering.CentroidClusterModel;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.GenerateNewMDRule;
import com.rapidminer.operator.ports.metadata.MDInteger;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.ModelMetaData;

public class ExtractClusterPrototypes
extends Operator {
    private InputPort modelInput = this.getInputPorts().createPort("model", CentroidClusterModel.class);
    private OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set");
    private OutputPort modelOutput = (OutputPort)this.getOutputPorts().createPort("model");

    public ExtractClusterPrototypes(OperatorDescription description) {
        super(description);
        this.getTransformer().addPassThroughRule(this.modelInput, this.modelOutput);
        this.getTransformer().addRule(new GenerateNewMDRule(this.exampleSetOutput, ExampleSet.class){

            @Override
            public MetaData modifyMetaData(MetaData unmodifiedMetaData) {
                if (ExtractClusterPrototypes.this.modelInput.getMetaData() instanceof ModelMetaData) {
                    ModelMetaData modelMetaData = (ModelMetaData)ExtractClusterPrototypes.this.modelInput.getMetaData();
                    ExampleSetMetaData emd = modelMetaData.getTrainingSetMetaData();
                    emd.setNumberOfExamples(new MDInteger());
                    return emd;
                }
                return super.modifyMetaData(unmodifiedMetaData);
            }
        });
    }

    @Override
    public void doWork() throws OperatorException {
        Attribute clusterAttribute;
        CentroidClusterModel model = (CentroidClusterModel)this.modelInput.getData();
        Attributes trainAttributes = model.getTrainingHeader().getAttributes();
        String[] attributeNames = model.getAttributeNames();
        Attribute[] attributes = new Attribute[attributeNames.length + 1];
        for (int i = 0; i < attributeNames.length; ++i) {
            Attribute originalAttribute = trainAttributes.get(attributeNames[i]);
            attributes[i] = AttributeFactory.createAttribute(attributeNames[i], originalAttribute.getValueType());
            if (!originalAttribute.isNominal()) continue;
            attributes[i].setMapping((NominalMapping)originalAttribute.getMapping().clone());
        }
        attributes[attributes.length - 1] = clusterAttribute = AttributeFactory.createAttribute("cluster", 1);
        MemoryExampleTable table = new MemoryExampleTable(attributes);
        for (int i = 0; i < model.getNumberOfClusters(); ++i) {
            double[] data = new double[attributeNames.length + 1];
            System.arraycopy(model.getCentroidCoordinates(i), 0, data, 0, attributeNames.length);
            data[attributeNames.length] = clusterAttribute.getMapping().mapString("cluster_" + i);
            table.addDataRow(new DoubleArrayDataRow(data));
        }
        ExampleSet resultSet = table.createExampleSet();
        resultSet.getAttributes().setSpecialAttribute(clusterAttribute, "cluster");
        this.modelOutput.deliver(model);
        this.exampleSetOutput.deliver(resultSet);
    }
}

