/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.clustering;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.clustering.ClusterModel;
import com.rapidminer.operator.clustering.FlatFuzzyClusterModel;
import com.rapidminer.operator.learner.PredictionModel;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetPassThroughRule;
import com.rapidminer.operator.ports.metadata.ExampleSetPrecondition;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.SimpleMetaDataError;
import java.util.HashMap;
import java.util.Vector;

public class ClusterToPrediction
extends Operator {
    private final InputPort exampleSetInput = (InputPort)this.getInputPorts().createPort("example set");
    private final InputPort clusterModelInput = this.getInputPorts().createPort("cluster model", ClusterModel.class);
    private final OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set");
    private final OutputPort clusterModelOutput = (OutputPort)this.getOutputPorts().createPort("cluster model");

    public ClusterToPrediction(OperatorDescription description) {
        super(description);
        this.exampleSetInput.addPrecondition(new ExampleSetPrecondition(this.exampleSetInput, -1, "label", "cluster"));
        this.getTransformer().addRule(new ExampleSetPassThroughRule(this.exampleSetInput, this.exampleSetOutput, null){

            @Override
            public MetaData modifyMetaData(MetaData metaData) {
                if (metaData instanceof ExampleSetMetaData) {
                    ExampleSetMetaData emd = (ExampleSetMetaData)metaData;
                    switch (emd.hasSpecial("label")) {
                        case NO: {
                            ClusterToPrediction.this.exampleSetInput.addError(new SimpleMetaDataError(ProcessSetupError.Severity.ERROR, (Port)ClusterToPrediction.this.exampleSetInput, "special_missing", "label"));
                            return emd;
                        }
                        case UNKNOWN: {
                            ClusterToPrediction.this.exampleSetInput.addError(new SimpleMetaDataError(ProcessSetupError.Severity.WARNING, (Port)ClusterToPrediction.this.exampleSetInput, "special_unknown", "label"));
                            return emd;
                        }
                        case YES: {
                            AttributeMetaData predictionMD = AttributeMetaData.createPredictionMetaData(emd.getLabelMetaData());
                            emd.addAttribute(predictionMD);
                            AttributeMetaData.createConfidenceAttributeMetaData(emd);
                            return emd;
                        }
                    }
                    return emd;
                }
                return metaData;
            }
        });
        this.getTransformer().addPassThroughRule(this.clusterModelInput, this.clusterModelOutput);
    }

    @Override
    public void doWork() throws OperatorException {
        int minimum;
        int i;
        int j;
        ExampleSet exampleSet = (ExampleSet)this.exampleSetInput.getData();
        ClusterModel model = (ClusterModel)this.clusterModelInput.getData();
        Attribute labelAttribute = exampleSet.getAttributes().getLabel();
        PredictionModel.createPredictedLabel(exampleSet, labelAttribute);
        Attribute predictedLabel = exampleSet.getAttributes().getPredictedLabel();
        HashMap<Integer, String> intToClusterMapping = new HashMap<Integer, String>();
        int[][] mappingTable = new int[model.getNumberOfClusters()][model.getNumberOfClusters()];
        int a = 0;
        for (int i2 = 0; i2 < model.getNumberOfClusters(); ++i2) {
            HashMap<String, Integer> labelOccurrence = new HashMap<String, Integer>();
            for (Example example : exampleSet) {
                String label = example.getValueAsString(labelAttribute);
                if (!labelOccurrence.containsKey(label)) {
                    labelOccurrence.put(label, 0);
                    if (i2 == 0) {
                        intToClusterMapping.put(a, label);
                        ++a;
                    }
                }
                if (example.getValue(example.getAttributes().getCluster()) != (double)i2) continue;
                labelOccurrence.put(label, (Integer)labelOccurrence.get(label) + 1);
            }
            if (i2 == 0 && model.getNumberOfClusters() != labelOccurrence.size()) {
                throw new UserError((Operator)this, 943, labelOccurrence.size(), model.getNumberOfClusters());
            }
            for (j = 0; j < mappingTable[i2].length; ++j) {
                int occ;
                String clusterName = (String)intToClusterMapping.get(j);
                mappingTable[i2][j] = occ = ((Integer)labelOccurrence.get(clusterName)).intValue();
            }
        }
        int maxValue = -1;
        for (i = 0; i < mappingTable.length; ++i) {
            for (j = 0; j < mappingTable[i].length; ++j) {
                if (mappingTable[i][j] <= maxValue) continue;
                maxValue = mappingTable[i][j];
            }
        }
        for (i = 0; i < mappingTable.length; ++i) {
            int j2;
            minimum = Integer.MAX_VALUE;
            for (j2 = 0; j2 < mappingTable[i].length; ++j2) {
                mappingTable[i][j2] = maxValue - mappingTable[i][j2];
                if (mappingTable[i][j2] >= minimum) continue;
                minimum = mappingTable[i][j2];
            }
            if (minimum <= 0) continue;
            for (j2 = 0; j2 < mappingTable[i].length; ++j2) {
                mappingTable[i][j2] = mappingTable[i][j2] - minimum;
            }
        }
        for (i = 0; i < mappingTable[0].length; ++i) {
            int j3;
            minimum = Integer.MAX_VALUE;
            for (j3 = 0; j3 < mappingTable.length; ++j3) {
                if (mappingTable[j3][i] >= minimum) continue;
                minimum = mappingTable[j3][i];
            }
            if (minimum <= 0) continue;
            for (j3 = 0; j3 < mappingTable.length; ++j3) {
                mappingTable[j3][i] = mappingTable[j3][i] - minimum;
            }
        }
        while (!this.assignmentAvailable(mappingTable)) {
            int j4;
            int i3;
            int i4;
            int j5;
            Vector<Integer> markedRows = new Vector<Integer>();
            Vector<Integer> markedColumns = new Vector<Integer>();
            for (int i5 = 0; i5 < mappingTable[0].length; ++i5) {
                boolean markedZero = false;
                for (j5 = 0; j5 < mappingTable.length; ++j5) {
                    if (mappingTable[j5][i5] != Integer.MIN_VALUE) continue;
                    markedZero = true;
                    break;
                }
                if (markedZero) continue;
                markedRows.add(i5);
            }
            boolean newMarked = true;
            while (newMarked) {
                newMarked = false;
                for (i4 = 0; i4 < mappingTable.length; ++i4) {
                    for (j5 = 0; j5 < mappingTable[i4].length; ++j5) {
                        if (mappingTable[i4][j5] != Integer.MAX_VALUE || !markedRows.contains(j5) || markedColumns.contains(i4)) continue;
                        newMarked = true;
                        markedColumns.add(i4);
                    }
                }
                for (i4 = 0; i4 < mappingTable[0].length; ++i4) {
                    for (j5 = 0; j5 < mappingTable.length; ++j5) {
                        if (mappingTable[j5][i4] != Integer.MIN_VALUE || !markedColumns.contains(j5) || markedRows.contains(i4)) continue;
                        newMarked = true;
                        markedRows.add(i4);
                    }
                }
            }
            for (i4 = 0; i4 < mappingTable.length; ++i4) {
                if (!markedColumns.contains(i4)) {
                    markedColumns.add(i4);
                    continue;
                }
                markedColumns.removeElement(i4);
            }
            int minimum2 = Integer.MAX_VALUE;
            for (i3 = 0; i3 < markedRows.size(); ++i3) {
                for (j4 = 0; j4 < markedColumns.size(); ++j4) {
                    if (mappingTable[(Integer)markedColumns.get(j4)][(Integer)markedRows.get(i3)] >= minimum2) continue;
                    minimum2 = mappingTable[(Integer)markedColumns.get(j4)][(Integer)markedRows.get(i3)];
                }
            }
            for (i3 = 0; i3 < markedRows.size(); ++i3) {
                for (j4 = 0; j4 < markedColumns.size(); ++j4) {
                    mappingTable[((Integer)markedColumns.get((int)j4)).intValue()][((Integer)markedRows.get((int)i3)).intValue()] = mappingTable[(Integer)markedColumns.get(j4)][(Integer)markedRows.get(i3)] - minimum2;
                }
            }
            for (i3 = 0; i3 < mappingTable.length; ++i3) {
                if (markedColumns.contains(i3)) continue;
                for (j4 = 0; j4 < mappingTable[i3].length; ++j4) {
                    if (markedRows.contains(j4)) continue;
                    mappingTable[i3][j4] = mappingTable[i3][j4] + minimum2;
                }
            }
            for (i3 = 0; i3 < mappingTable.length; ++i3) {
                for (j4 = 0; j4 < mappingTable[i3].length; ++j4) {
                    if (mappingTable[i3][j4] == Integer.MAX_VALUE) {
                        mappingTable[i3][j4] = 0;
                    }
                    if (mappingTable[i3][j4] != Integer.MIN_VALUE) continue;
                    mappingTable[i3][j4] = 0;
                }
            }
        }
        HashMap<Integer, String> clusterToPrediction = new HashMap<Integer, String>();
        for (int i6 = 0; i6 < mappingTable.length; ++i6) {
            int result = -1;
            for (int j6 = 0; j6 < mappingTable[i6].length; ++j6) {
                if (mappingTable[i6][j6] != Integer.MIN_VALUE) continue;
                result = j6;
                break;
            }
            String resultCluster = (String)intToClusterMapping.get(result);
            clusterToPrediction.put(i6, resultCluster);
        }
        HashMap<String, Integer> predictionToCluster = new HashMap<String, Integer>();
        int i7 = 0;
        Attribute clusterAttribute = exampleSet.getAttributes().getCluster();
        for (Example example : exampleSet) {
            String resultLabel = (String)clusterToPrediction.get((int)example.getValue(example.getAttributes().getCluster()));
            example.setValue(predictedLabel, resultLabel);
            if (predictionToCluster.size() < model.getNumberOfClusters() && !predictionToCluster.containsKey(example.getValueAsString(example.getAttributes().getPredictedLabel()))) {
                String clusterNumber = example.getValueAsString(clusterAttribute).replaceAll("[^\\d]+", "");
                try {
                    int number = Integer.parseInt(clusterNumber);
                    predictionToCluster.put(example.getValueAsString(example.getAttributes().getPredictedLabel()), number);
                }
                catch (NumberFormatException e) {
                    throw new UserError((Operator)this, 145, clusterAttribute.getName());
                }
            }
            ++i7;
        }
        i7 = 0;
        for (Example example : exampleSet) {
            if (model.getClass() == FlatFuzzyClusterModel.class) {
                FlatFuzzyClusterModel fuzzyModel = (FlatFuzzyClusterModel)model;
                for (int j7 = 0; j7 < clusterToPrediction.size(); ++j7) {
                    String label = (String)clusterToPrediction.get(j7);
                    example.setConfidence(label, fuzzyModel.getExampleInClusterProbability(i7, (Integer)predictionToCluster.get(label)));
                }
            } else {
                example.setConfidence((String)clusterToPrediction.get((int)example.getValue(example.getAttributes().getCluster())), 1.0);
            }
            ++i7;
        }
        this.exampleSetOutput.deliver(exampleSet);
        this.clusterModelOutput.deliver(model);
    }

    private boolean assignmentAvailable(int[][] mappingTable) {
        int markedZeros = 0;
        boolean modificationDone = true;
        while (modificationDone) {
            int j;
            while (modificationDone) {
                int k;
                int position;
                int i;
                modificationDone = false;
                for (i = 0; i < mappingTable.length; ++i) {
                    position = -1;
                    for (j = 0; j < mappingTable[i].length; ++j) {
                        if (mappingTable[i][j] != 0) continue;
                        if (position == -1) {
                            position = j;
                            continue;
                        }
                        position = -1;
                        break;
                    }
                    if (position == -1) continue;
                    modificationDone = true;
                    mappingTable[i][position] = Integer.MIN_VALUE;
                    for (k = 0; k < mappingTable.length; ++k) {
                        if (mappingTable[k][position] != 0) continue;
                        mappingTable[k][position] = Integer.MAX_VALUE;
                    }
                    ++markedZeros;
                }
                if (markedZeros == mappingTable.length) {
                    return true;
                }
                for (i = 0; i < mappingTable[0].length; ++i) {
                    position = -1;
                    for (j = 0; j < mappingTable.length; ++j) {
                        if (mappingTable[j][i] != 0) continue;
                        if (position == -1) {
                            position = j;
                            continue;
                        }
                        position = -1;
                        break;
                    }
                    if (position == -1) continue;
                    modificationDone = true;
                    mappingTable[position][i] = Integer.MIN_VALUE;
                    for (k = 0; k < mappingTable[0].length; ++k) {
                        if (mappingTable[position][k] != 0) continue;
                        mappingTable[position][k] = Integer.MAX_VALUE;
                    }
                    ++markedZeros;
                }
                if (markedZeros != mappingTable.length) continue;
                return true;
            }
            int aktMarkedZeros = markedZeros;
            for (int i = 0; i < mappingTable.length; ++i) {
                for (j = 0; j < mappingTable[i].length; ++j) {
                    int k;
                    if (mappingTable[i][j] != 0) continue;
                    mappingTable[i][j] = Integer.MIN_VALUE;
                    for (k = j + 1; k < mappingTable[i].length; ++k) {
                        if (mappingTable[i][k] != 0) continue;
                        mappingTable[i][k] = Integer.MAX_VALUE;
                    }
                    for (k = 0; k < mappingTable.length; ++k) {
                        if (mappingTable[k][j] != 0) continue;
                        mappingTable[k][j] = Integer.MAX_VALUE;
                    }
                    modificationDone = true;
                    ++markedZeros;
                    break;
                }
                if (aktMarkedZeros != markedZeros) break;
            }
            if (markedZeros != mappingTable.length) continue;
            return true;
        }
        return false;
    }
}

