/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.clustering;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.ConditionedExampleSet;
import com.rapidminer.example.set.NoMissingAttributeValueCondition;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.clustering.ClusterModel;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.AttributeAddingExampleSetPassThroughRule;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.PassThroughRule;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import java.util.List;

public class ClusterModel2ExampleSet
extends Operator {
    private InputPort exampleSetInput = this.getInputPorts().createPort("example set", new ExampleSetMetaData());
    private InputPort modelInput = this.getInputPorts().createPort("model", ClusterModel.class);
    private OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set");
    private OutputPort modelOutput = (OutputPort)this.getOutputPorts().createPort("model");
    public static final String PARAMETER_KEEP_MODEL = "keep_model";
    public static final String PARAMETER_REMOVE_UNLABELED = "remove_unlabeled";
    public static final String PARAMETER_ADD_AS_LABEL = "add_as_label";

    public ClusterModel2ExampleSet(OperatorDescription description) {
        super(description);
        this.getTransformer().addRule(new AttributeAddingExampleSetPassThroughRule(this.exampleSetInput, this.exampleSetOutput, new AttributeMetaData("cluster", 1, "cluster")));
        this.getTransformer().addRule(new PassThroughRule(this.modelInput, this.modelOutput, false));
    }

    public ExampleSet addClusterAttribute(ExampleSet exampleSet, ClusterModel model) throws OperatorException {
        Attribute targetAttribute;
        Attributes attributes = exampleSet.getAttributes();
        model.checkCapabilities(exampleSet);
        if (!this.getParameterAsBoolean(PARAMETER_ADD_AS_LABEL)) {
            targetAttribute = AttributeFactory.createAttribute("cluster", 1);
            exampleSet.getExampleTable().addAttribute(targetAttribute);
            attributes.setCluster(targetAttribute);
        } else {
            targetAttribute = AttributeFactory.createAttribute("label", 1);
            exampleSet.getExampleTable().addAttribute(targetAttribute);
            attributes.setLabel(targetAttribute);
        }
        int[] clusterIndices = model.getClusterAssignments(exampleSet);
        int i = 0;
        for (Example example : exampleSet) {
            if (clusterIndices[i] != -1) {
                example.setValue(targetAttribute, model.getCluster(clusterIndices[i]).toString());
            } else {
                example.setValue(targetAttribute, Double.NaN);
            }
            ++i;
        }
        if (this.getParameterAsBoolean(PARAMETER_REMOVE_UNLABELED)) {
            exampleSet = new ConditionedExampleSet(exampleSet, new NoMissingAttributeValueCondition(exampleSet, targetAttribute.getName()));
        }
        return exampleSet;
    }

    @Override
    public void doWork() throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)this.exampleSetInput.getData();
        ClusterModel model = (ClusterModel)this.modelInput.getData();
        exampleSet = this.addClusterAttribute(exampleSet, model);
        this.exampleSetOutput.deliver(exampleSet);
        this.modelOutput.deliver(model);
    }

    @Override
    public boolean shouldAutoConnect(OutputPort port) {
        if (port == this.modelOutput) {
            return this.getParameterAsBoolean(PARAMETER_KEEP_MODEL);
        }
        return super.shouldAutoConnect(port);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeBoolean type = new ParameterTypeBoolean(PARAMETER_ADD_AS_LABEL, "Should the cluster values be added as label.", false);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_REMOVE_UNLABELED, "Delete the unlabeled examples.", false);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_KEEP_MODEL, "Specifies if input model should be kept.", true);
        type.setDeprecated();
        types.add(type);
        return types;
    }
}

