/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.clustering;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.example.set.ConditionedExampleSet;
import com.rapidminer.example.set.NoMissingAttributeValueCondition;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.NominalMapping;
import com.rapidminer.operator.AbstractModel;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.clustering.Cluster;
import com.rapidminer.operator.clustering.ClusterModelInterface;
import java.util.ArrayList;
import java.util.Collection;

public class ClusterModel
extends AbstractModel
implements ClusterModelInterface {
    public static final int UNASSIGNABLE = -1;
    private static final long serialVersionUID = 3780908886210272852L;
    private boolean isAddingAsLabel;
    private boolean isRemovingUnknown;
    private ArrayList<Cluster> clusters;

    public ClusterModel(ExampleSet exampleSet, int k, boolean addClusterAsLabel, boolean removeUnknown) {
        super(exampleSet);
        this.clusters = new ArrayList(k);
        for (int i = 0; i < k; ++i) {
            this.clusters.add(new Cluster(i));
        }
        this.isAddingAsLabel = addClusterAsLabel;
        this.isRemovingUnknown = removeUnknown;
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        Attribute targetAttribute;
        Attributes attributes = exampleSet.getAttributes();
        this.checkCapabilities(exampleSet);
        if (!this.isAddingAsLabel) {
            targetAttribute = AttributeFactory.createAttribute("cluster", 1);
            exampleSet.getExampleTable().addAttribute(targetAttribute);
            attributes.setCluster(targetAttribute);
        } else {
            targetAttribute = AttributeFactory.createAttribute("label", 1);
            exampleSet.getExampleTable().addAttribute(targetAttribute);
            attributes.setLabel(targetAttribute);
        }
        int[] clusterIndices = this.getClusterAssignments(exampleSet);
        int i = 0;
        for (Example example : exampleSet) {
            if (clusterIndices[i] != -1) {
                example.setValue(targetAttribute, "cluster_" + clusterIndices[i]);
            } else {
                example.setValue(targetAttribute, Double.NaN);
            }
            ++i;
        }
        if (this.isRemovingUnknown) {
            exampleSet = new ConditionedExampleSet(exampleSet, new NoMissingAttributeValueCondition(exampleSet, targetAttribute.getName()));
        }
        return exampleSet;
    }

    public int getNumberOfClusters() {
        return this.clusters.size();
    }

    public void setClusterAssignments(int[] clusterId, ExampleSet exampleSet) {
        Attribute id = exampleSet.getAttributes().getId();
        if (id.isNominal()) {
            NominalMapping mapping = id.getMapping();
            int i = 0;
            for (Example example : exampleSet) {
                this.getCluster(clusterId[i]).assignExample(mapping.mapIndex((int)example.getValue(id)));
                ++i;
            }
        } else {
            int i = 0;
            for (Example example : exampleSet) {
                this.getCluster(clusterId[i]).assignExample(example.getValue(id));
                ++i;
            }
        }
    }

    public int[] getClusterAssignments(ExampleSet exampleSet) {
        int[] clusterAssignments = new int[exampleSet.size()];
        Attribute idAttribute = exampleSet.getAttributes().getId();
        if (idAttribute.isNominal()) {
            int j = 0;
            for (Example example : exampleSet) {
                clusterAssignments[j] = this.getClusterIndexOfId(example.getValueAsString(idAttribute));
                ++j;
            }
        } else {
            int j = 0;
            for (Example example : exampleSet) {
                clusterAssignments[j] = this.getClusterIndexOfId(example.getValue(idAttribute));
                ++j;
            }
        }
        return clusterAssignments;
    }

    public int getClusterIndexOfId(Object id) {
        int index = 0;
        for (Cluster cluster : this.clusters) {
            if (cluster.containsExampleId(id)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public Cluster getCluster(int i) {
        return this.clusters.get(i);
    }

    public Collection<Cluster> getClusters() {
        return this.clusters;
    }

    @Override
    public String getExtension() {
        return "cm";
    }

    @Override
    public String getFileDescription() {
        return "Cluster model";
    }

    public void checkCapabilities(ExampleSet exampleSet) throws OperatorException {
        Tools.isIdTagged(exampleSet);
    }

    @Override
    public String getName() {
        return "Cluster Model";
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer();
        int sum = 0;
        for (int i = 0; i < this.getNumberOfClusters(); ++i) {
            Cluster cl = this.getCluster(i);
            int numObjects = cl.getNumberOfExamples();
            result.append("Cluster " + cl.getClusterId() + ": " + numObjects + " items" + com.rapidminer.tools.Tools.getLineSeparator());
            sum += numObjects;
        }
        result.append("Total number of items: " + sum + com.rapidminer.tools.Tools.getLineSeparator());
        return result.toString();
    }
}

