/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.clustering;

import com.rapidminer.tools.Tools;
import java.io.Serializable;
import java.util.Collection;

public class Centroid
implements Serializable {
    private static final long serialVersionUID = 1L;
    private double[] centroid;
    private double[] centroidSum;
    private int numberOfAssigned = 0;

    public Centroid(int numberOfDimensions) {
        this.centroid = new double[numberOfDimensions];
        this.centroidSum = new double[numberOfDimensions];
    }

    public double[] getCentroid() {
        return this.centroid;
    }

    public void setCentroid(double[] coordinates) {
        this.centroid = coordinates;
    }

    public void assignExample(double[] exampleValues) {
        ++this.numberOfAssigned;
        for (int i = 0; i < exampleValues.length; ++i) {
            int n = i;
            this.centroidSum[n] = this.centroidSum[n] + exampleValues[i];
        }
    }

    public boolean finishAssign() {
        double[] newCentroid = new double[this.centroid.length];
        boolean stable = true;
        for (int i = 0; i < this.centroid.length; ++i) {
            newCentroid[i] = this.centroidSum[i] / (double)this.numberOfAssigned;
            stable &= Double.compare(newCentroid[i], this.centroid[i]) == 0;
        }
        this.centroid = newCentroid;
        this.centroidSum = new double[this.centroidSum.length];
        this.numberOfAssigned = 0;
        return stable;
    }

    public String toString(Collection<String> dimensionNames) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        for (String dimName : dimensionNames) {
            buffer.append(dimName + ":\t");
            buffer.append(Tools.formatNumber(this.centroid[i]) + Tools.getLineSeparator());
            if (++i <= 100) continue;
            break;
        }
        return buffer.toString();
    }
}

