/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.associations;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.ExampleTable;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.associations.AssociationRule;
import com.rapidminer.operator.learner.associations.AssociationRules;
import com.rapidminer.operator.learner.associations.Item;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.ExampleSetPassThroughRule;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.container.Pair;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class AssociationRulesApplier
extends Operator {
    public static final String PARAMETER_POSITIVE_VALUE = "positive_value";
    public static final String PARAMETER_CONFIDENCE_AGGREGATION = "confidence_aggregation_method";
    public static final String[] AGGREGATION_METHOD = new String[]{"binary", "aggregated confidence", "aggregated conviction", "aggregated LaPlace", "aggregated gain", "aggregated lift"};
    public static final int BINARY = 0;
    public static final int MAX_CONFIDENCE = 1;
    public static final int MAX_CONVICTION = 2;
    public static final int MAX_LA_PLACE = 3;
    public static final int MAX_GAIN = 4;
    public static final int MAX_LIFT = 5;
    private InputPort exampleSetInput = this.getInputPorts().createPort("example set", ExampleSet.class);
    private InputPort associationRulesInput = this.getInputPorts().createPort("association rules", AssociationRules.class);
    private OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set");

    public AssociationRulesApplier(OperatorDescription description) {
        super(description);
        this.getTransformer().addRule(new ExampleSetPassThroughRule(this.exampleSetInput, this.exampleSetOutput, SetRelation.SUPERSET));
    }

    @Override
    public void doWork() throws OperatorException {
        AssociationRules rules = (AssociationRules)this.associationRulesInput.getData();
        ExampleSet exampleSet = (ExampleSet)this.exampleSetInput.getData();
        exampleSet = (ExampleSet)exampleSet.clone();
        Tools.onlyNominalAttributes(exampleSet, "FPGrowth");
        int selectedAggregation = this.getParameterAsInt(PARAMETER_CONFIDENCE_AGGREGATION);
        String positiveValueString = null;
        try {
            positiveValueString = this.getParameterAsString(PARAMETER_POSITIVE_VALUE);
        }
        catch (UndefinedParameterError err) {
            // empty catch block
        }
        HashMap<String, Pair<Attribute, Double>> nameAttributePositiveValueMap = new HashMap<String, Pair<Attribute, Double>>();
        for (Attribute attribute : exampleSet.getAttributes()) {
            double positiveIndice = attribute.getMapping().getPositiveIndex();
            if (positiveValueString != null && !positiveValueString.equals("")) {
                positiveIndice = attribute.getMapping().mapString(positiveValueString);
            }
            nameAttributePositiveValueMap.put(attribute.getName(), new Pair<Attribute, Double>(attribute, positiveIndice));
        }
        Item[] conclusionItems = rules.getAllConclusionItems();
        Arrays.sort(conclusionItems, new Comparator<Item>(){

            @Override
            public int compare(Item o1, Item o2) {
                return ((Object)o1).toString().compareTo(((Object)o2).toString());
            }
        });
        HashMap<Item, Attribute> itemConfidenceAttributeMap = new HashMap<Item, Attribute>();
        Attribute[] attributes = new Attribute[conclusionItems.length];
        int i = 0;
        for (Item item : conclusionItems) {
            attributes[i] = AttributeFactory.createAttribute("confidence(" + ((Object)item).toString() + ")", 4);
            itemConfidenceAttributeMap.put(item, attributes[i]);
            ++i;
        }
        ExampleTable exampleTable = exampleSet.getExampleTable();
        exampleTable.addAttributes(Arrays.asList(attributes));
        for (i = 0; i < attributes.length; ++i) {
            AttributeRole currentRole = new AttributeRole(attributes[i]);
            currentRole.setSpecial(attributes[i].getName());
            exampleSet.getAttributes().add(currentRole);
        }
        for (Example example : exampleSet) {
            for (Attribute confAttribute : attributes) {
                example.setValue(confAttribute, 0.0);
            }
            for (i = 0; i < rules.getNumberOfRules(); ++i) {
                boolean premiseFullfilled;
                Pair attributePositiveValuePair;
                AssociationRule currentRule = rules.getRule(i);
                Iterator<Item> premiseIterator = currentRule.getPremiseItems();
                for (premiseFullfilled = true; premiseIterator.hasNext() && premiseFullfilled; premiseFullfilled &= ((Double)attributePositiveValuePair.getSecond()).equals(example.getValue((Attribute)attributePositiveValuePair.getFirst()))) {
                    Item premiseItem = premiseIterator.next();
                    String attributeName = ((Object)premiseItem).toString();
                    attributePositiveValuePair = (Pair)nameAttributePositiveValueMap.get(attributeName);
                }
                if (!premiseFullfilled) continue;
                Iterator<Item> conclusionIterator = currentRule.getConclusionItems();
                while (conclusionIterator.hasNext()) {
                    Item conclusionItem = conclusionIterator.next();
                    Attribute attribute = (Attribute)itemConfidenceAttributeMap.get(conclusionItem);
                    double ruleConfidence = this.getConfidence(currentRule, example.getValue(attribute), selectedAggregation);
                    example.setValue(attribute, ruleConfidence);
                }
            }
        }
        this.exampleSetOutput.deliver(exampleSet);
    }

    private double getConfidence(AssociationRule currentRule, double currentSummedConfidence, int selectedAggregation) {
        switch (selectedAggregation) {
            case 0: {
                return 1.0;
            }
            case 1: {
                return Math.max(currentSummedConfidence, currentRule.getConfidence());
            }
            case 2: {
                return Math.max(currentSummedConfidence, currentRule.getConviction());
            }
            case 4: {
                return Math.max(currentSummedConfidence, currentRule.getGain());
            }
            case 3: {
                return Math.max(currentSummedConfidence, currentRule.getLaplace());
            }
            case 5: {
                return Math.max(currentSummedConfidence, currentRule.getLift());
            }
        }
        return 0.0;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeCategory(PARAMETER_CONFIDENCE_AGGREGATION, "This selects the method to aggregat the confidence on the items in each fulfilled conclusion.", AGGREGATION_METHOD, 0, false);
        types.add(type);
        type = new ParameterTypeString(PARAMETER_POSITIVE_VALUE, "This parameter determines, which value of the binominal attributes is treated as positive. Attributes with that value are considered as part of a transaction. If left blank, the example set determines, which is value is used.", true);
        type.setExpert(true);
        types.add(type);
        return types;
    }
}

