/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.annotation;

import java.text.DecimalFormat;

public class PolynomialFunction {
    private double coefficient;
    private double degreeExamples;
    private double degreeAttributes;
    private double logDegreeExamples;
    private double logDegreeAttributes;

    public PolynomialFunction(double coefficient, double degreeExamples, double degreeAttributes) {
        this(coefficient, degreeExamples, 0.0, degreeAttributes, 0.0);
    }

    public PolynomialFunction(double coefficient, double degreeExamples, double logDegreeExamples, double degreeAttributes, double logDegreeAttributes) {
        this.coefficient = coefficient;
        this.degreeAttributes = degreeAttributes;
        this.degreeExamples = degreeExamples;
        this.logDegreeAttributes = logDegreeAttributes;
        this.logDegreeExamples = logDegreeExamples;
    }

    public static PolynomialFunction makeLinearFunction(double coefficient) {
        return new PolynomialFunction(coefficient, 1.0, 1.0);
    }

    public long evaluate(int numExamples, int numAttributes) {
        return (long)(this.coefficient * Math.pow(numExamples, this.degreeExamples) * Math.pow(Math.log(numExamples), this.logDegreeExamples) * Math.pow(numAttributes, this.degreeAttributes) * Math.pow(Math.log(numAttributes), this.logDegreeAttributes));
    }

    public String toString() {
        if (this.coefficient == 0.0 || this.coefficient == -0.0) {
            return "n/a";
        }
        DecimalFormat formatter = new DecimalFormat("#.##");
        StringBuffer resourceString = new StringBuffer();
        resourceString.append("f() = ");
        resourceString.append(formatter.format(this.coefficient));
        if (this.degreeExamples > 0.0 || this.degreeAttributes > 0.0) {
            resourceString.append(" * (");
        }
        if (this.degreeExamples > 0.0) {
            if (this.logDegreeExamples > 0.0) {
                resourceString.append("log");
                resourceString.append(formatter.format(this.logDegreeExamples));
                if (this.degreeExamples > 1.0) {
                    resourceString.append("(examples^");
                    resourceString.append(formatter.format(this.degreeExamples));
                } else {
                    resourceString.append("(examples");
                }
                resourceString.append(')');
            } else if (this.degreeExamples > 1.0) {
                resourceString.append("examples^");
                resourceString.append(formatter.format(this.degreeExamples));
            } else {
                resourceString.append("examples");
            }
            if (this.degreeAttributes > 0.0) {
                resourceString.append(" * ");
            }
        }
        if (this.degreeAttributes > 0.0) {
            if (this.logDegreeAttributes > 0.0) {
                resourceString.append("log");
                resourceString.append(formatter.format(this.logDegreeAttributes));
                if (this.degreeAttributes > 1.0) {
                    resourceString.append("(attributes^");
                    resourceString.append(formatter.format(this.degreeAttributes));
                } else {
                    resourceString.append("(attributes");
                }
                resourceString.append(')');
            } else if (this.degreeAttributes > 1.0) {
                resourceString.append("attributes^");
                resourceString.append(formatter.format(this.degreeAttributes));
            } else {
                resourceString.append("attributes");
            }
        }
        if (this.degreeExamples > 0.0 || this.degreeAttributes > 0.0) {
            resourceString.append(')');
        }
        return resourceString.toString();
    }
}

