/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.annotation;

import com.rapidminer.operator.annotation.ExampleSetResourceConsumptionEstimator;
import com.rapidminer.operator.annotation.PolynomialFunction;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MDInteger;
import com.rapidminer.operator.tools.AttributeSubsetSelector;

public class PolynomialExampleSetResourceConsumptionEstimator
extends ExampleSetResourceConsumptionEstimator {
    private final PolynomialFunction cpuFunction;
    private final PolynomialFunction memoryFunction;

    public PolynomialExampleSetResourceConsumptionEstimator(InputPort in, AttributeSubsetSelector selector, PolynomialFunction cpuFunction, PolynomialFunction memoryFunction) {
        super(in, selector);
        this.cpuFunction = cpuFunction;
        this.memoryFunction = memoryFunction;
    }

    protected int getNumberOfRelevantAttributes(ExampleSetMetaData emd) {
        return emd.getNumberOfRegularAttributes();
    }

    @Override
    public long estimateMemory(ExampleSetMetaData exampleSet) {
        MDInteger numEx = exampleSet.getNumberOfExamples();
        if (numEx == null) {
            return -1L;
        }
        if ((Integer)numEx.getNumber() == 0) {
            return -1L;
        }
        int numAtt = this.getNumberOfRelevantAttributes(exampleSet);
        return this.cpuFunction.evaluate((Integer)numEx.getNumber(), numAtt);
    }

    @Override
    public long estimateRuntime(ExampleSetMetaData exampleSet) {
        MDInteger numEx = exampleSet.getNumberOfExamples();
        if (numEx == null) {
            return -1L;
        }
        if ((Integer)numEx.getNumber() == 0) {
            return -1L;
        }
        int numAtt = exampleSet.getNumberOfRegularAttributes();
        return this.memoryFunction.evaluate((Integer)numEx.getNumber(), numAtt);
    }

    @Override
    public PolynomialFunction getCpuFunction() {
        return this.cpuFunction;
    }

    @Override
    public PolynomialFunction getMemoryFunction() {
        return this.memoryFunction;
    }
}

