/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.annotation;

import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.tools.AttributeSubsetSelector;

public abstract class ExampleSetResourceConsumptionEstimator
implements ResourceConsumptionEstimator {
    private InputPort inputPort;
    private AttributeSubsetSelector selector;

    public ExampleSetResourceConsumptionEstimator(InputPort inputPort, AttributeSubsetSelector selector) {
        this.inputPort = inputPort;
        this.selector = selector;
    }

    public abstract long estimateMemory(ExampleSetMetaData var1);

    public abstract long estimateRuntime(ExampleSetMetaData var1);

    @Override
    public long estimateMemoryConsumption() {
        ExampleSetMetaData exampleSet = this.getExampleSet();
        if (exampleSet == null) {
            return -1L;
        }
        return this.estimateMemory(exampleSet);
    }

    @Override
    public long estimateRuntime() {
        ExampleSetMetaData exampleSet = this.getExampleSet();
        if (exampleSet == null) {
            return -1L;
        }
        return this.estimateRuntime(exampleSet);
    }

    protected ExampleSetMetaData getExampleSet() {
        MetaData md = this.inputPort.getMetaData();
        if (md instanceof ExampleSetMetaData) {
            if (this.selector != null) {
                return this.selector.getMetaDataSubset((ExampleSetMetaData)md, false);
            }
            return (ExampleSetMetaData)md;
        }
        return null;
    }
}

