/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.NoBugError;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.Tools;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class UserError
extends OperatorException
implements NoBugError {
    private static final long serialVersionUID = -8441036860570180869L;
    private static ResourceBundle messages = I18N.getUserErrorMessagesBundle();
    private static final MessageFormat formatter = new MessageFormat("");
    private String errorIdentifier = null;
    private final int code;
    private transient Operator operator;

    public UserError(Operator operator, Throwable cause, int code, Object ... arguments) {
        super(UserError.getErrorMessage(code, arguments), cause);
        this.code = code;
        this.operator = operator;
    }

    public UserError(Operator operator, Throwable cause, int code) {
        this(operator, code, new Object[0], cause);
    }

    public UserError(Operator operator, int code, Object ... arguments) {
        this(operator, (Throwable)null, code, arguments);
    }

    public UserError(Operator operator, int code) {
        this(operator, (Throwable)null, code, new Object[0]);
    }

    public UserError(Operator operator, Throwable cause, String errorId, Object ... arguments) {
        super(UserError.getErrorMessage(errorId, arguments), cause);
        this.code = -1;
        this.errorIdentifier = errorId;
        this.operator = operator;
    }

    public UserError(Operator operator, Throwable cause, String errorId) {
        this(operator, cause, errorId, new Object[0]);
    }

    public UserError(Operator operator, String errorId, Object ... arguments) {
        this(operator, null, errorId, arguments);
    }

    public UserError(Operator operator, String errorId) {
        this(operator, null, errorId, new Object[0]);
    }

    @Override
    public String getDetails() {
        if (this.errorIdentifier == null) {
            return UserError.getResourceString(this.code, "long", "Description missing.");
        }
        return UserError.getResourceString(this.errorIdentifier, "long", "Description missing.");
    }

    @Override
    public String getErrorName() {
        if (this.errorIdentifier == null) {
            return UserError.getResourceString(this.code, "name", "Unnamed error.");
        }
        return UserError.getResourceString(this.errorIdentifier, "name", "Unnamed error.");
    }

    @Override
    public int getCode() {
        return this.code;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    public static String getErrorMessage(int code, Object[] arguments) {
        String message = UserError.getResourceString(code, "short", "No message.");
        try {
            formatter.applyPattern(message);
            String formatted = formatter.format(arguments);
            return formatted;
        }
        catch (Throwable t) {
            return message;
        }
    }

    public static String getErrorMessage(String identifier, Object[] arguments) {
        String message = UserError.getResourceString(identifier, "short", "No message.");
        try {
            formatter.applyPattern(message);
            String formatted = formatter.format(arguments);
            return formatted;
        }
        catch (Throwable t) {
            return message;
        }
    }

    public static String getResourceString(int code, String key, String deflt) {
        return UserError.getResourceString(code + "", key, deflt);
    }

    public static String getResourceString(String id, String key, String deflt) {
        if (messages == null) {
            return deflt;
        }
        try {
            return messages.getString("error." + id + "." + key);
        }
        catch (MissingResourceException e) {
            return deflt;
        }
    }

    @Override
    public String getHTMLMessage() {
        return "<html>Error in: <b>" + this.getOperator() + "</b><br>" + Tools.escapeXML(this.getMessage()) + "</html>";
    }
}

