/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ValueString;
import com.rapidminer.operator.ports.DummyPortPairExtender;
import com.rapidminer.operator.ports.PortPairExtender;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import java.util.List;

public class SingleMacroDefinitionOperator
extends Operator {
    public static final String PARAMETER_MACRO = "macro";
    public static final String PARAMETER_VALUE = "value";
    private PortPairExtender dummyPorts = new DummyPortPairExtender("through", this.getInputPorts(), this.getOutputPorts());

    public SingleMacroDefinitionOperator(OperatorDescription description) {
        super(description);
        this.dummyPorts.start();
        this.getTransformer().addRule(this.dummyPorts.makePassThroughRule());
        this.addValue(new ValueString("macro_name", "The name of the macro."){

            @Override
            public String getStringValue() {
                try {
                    return SingleMacroDefinitionOperator.this.getParameterAsString(SingleMacroDefinitionOperator.PARAMETER_MACRO);
                }
                catch (UndefinedParameterError e) {
                    return null;
                }
            }
        });
        this.addValue(new ValueString("macro_value", "The value of the macro."){

            @Override
            public String getStringValue() {
                try {
                    return SingleMacroDefinitionOperator.this.getParameterAsString(SingleMacroDefinitionOperator.PARAMETER_VALUE);
                }
                catch (UndefinedParameterError e) {
                    return null;
                }
            }
        });
    }

    @Override
    public void doWork() throws OperatorException {
        String macro = this.getParameterAsString(PARAMETER_MACRO);
        String value = this.getParameterAsString(PARAMETER_VALUE);
        this.getProcess().getMacroHandler().addMacro(macro, value);
        this.dummyPorts.passDataThrough();
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeString(PARAMETER_MACRO, "The macro name defined by the user.", false, false));
        types.add(new ParameterTypeString(PARAMETER_VALUE, "The macro value defined by the user.", false, false));
        return types;
    }
}

