/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.ports.PortOwner;
import com.rapidminer.operator.ports.quickfix.QuickFix;
import com.rapidminer.tools.I18N;
import java.util.Collections;
import java.util.List;

public class SimpleProcessSetupError
implements ProcessSetupError {
    private String i18nKey;
    private final Object[] i18nArgs;
    private final PortOwner owner;
    private final List<? extends QuickFix> fixes;
    private final ProcessSetupError.Severity severity;

    public SimpleProcessSetupError(ProcessSetupError.Severity severity, PortOwner owner, String i18nKey, Object ... i18nArgs) {
        this(severity, owner, Collections.emptyList(), false, i18nKey, i18nArgs);
    }

    public SimpleProcessSetupError(ProcessSetupError.Severity severity, PortOwner owner, List<? extends QuickFix> fixes, String i18nKey, Object ... i18nArgs) {
        this(severity, owner, fixes, false, i18nKey, i18nArgs);
    }

    public SimpleProcessSetupError(ProcessSetupError.Severity severity, PortOwner portOwner, List<? extends QuickFix> fixes, boolean absoluteKey, String i18nKey, Object ... i18nArgs) {
        this.i18nKey = absoluteKey ? i18nKey : "process.error." + i18nKey;
        this.i18nArgs = i18nArgs;
        this.owner = portOwner;
        this.fixes = fixes;
        this.severity = severity;
    }

    @Override
    public final String getMessage() {
        if (this.i18nArgs == null) {
            return I18N.getErrorBundle().getString(this.i18nKey);
        }
        return I18N.getMessage(I18N.getErrorBundle(), this.i18nKey, this.i18nArgs);
    }

    @Override
    public final PortOwner getOwner() {
        return this.owner;
    }

    @Override
    public List<? extends QuickFix> getQuickFixes() {
        return this.fixes;
    }

    @Override
    public final ProcessSetupError.Severity getSeverity() {
        return this.severity;
    }

    public final String toString() {
        if (this.i18nArgs == null) {
            return I18N.getErrorBundle().getString(this.i18nKey);
        }
        return I18N.getMessage(I18N.getErrorBundle(), this.i18nKey, this.i18nArgs);
    }
}

