/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPortExtender;
import com.rapidminer.operator.ports.OutputPortExtender;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeText;
import com.rapidminer.parameter.TextType;
import com.rapidminer.tools.plugin.Plugin;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class ScriptingOperator
extends Operator {
    private InputPortExtender inExtender = new InputPortExtender("input", this.getInputPorts());
    private OutputPortExtender outExtender = new OutputPortExtender("output", this.getOutputPorts());
    public static final String PARAMETER_SCRIPT = "script";
    public static final String PARAMETER_STANDARD_IMPORTS = "standard_imports";

    public ScriptingOperator(OperatorDescription description) {
        super(description);
        this.inExtender.start();
        this.outExtender.start();
    }

    @Override
    public void doWork() throws OperatorException {
        Object result;
        String script = this.getParameterAsString(PARAMETER_SCRIPT);
        if (this.getParameterAsBoolean(PARAMETER_STANDARD_IMPORTS)) {
            StringBuffer imports = new StringBuffer();
            imports.append("import com.rapidminer.example.*;\n");
            imports.append("import com.rapidminer.example.set.*;\n");
            imports.append("import com.rapidminer.example.table.*;\n");
            imports.append("import com.rapidminer.operator.*;\n");
            imports.append("import com.rapidminer.tools.Tools;\n");
            imports.append("import java.util.*;\n");
            script = imports.toString() + script;
        }
        try {
            GroovyShell shell = new GroovyShell(Plugin.getMajorClassLoader());
            List input = this.inExtender.getData(false);
            shell.setVariable("input", input);
            shell.setVariable("operator", (Object)this);
            Script parsedScript = shell.parse(script);
            result = parsedScript.run();
        }
        catch (Throwable e) {
            throw new UserError((Operator)this, e, 945, "Groovy", e);
        }
        if (result instanceof Object[]) {
            this.outExtender.deliver(Arrays.asList((IOObject[])result));
        } else if (result instanceof List) {
            LinkedList<IOObject> results = new LinkedList<IOObject>();
            for (Object single : (List)result) {
                if (single instanceof IOObject) {
                    results.add((IOObject)single);
                    continue;
                }
                this.getLogger().warning("Unknown result type: " + single);
            }
            this.outExtender.deliver(results);
        } else if (result != null) {
            if (result instanceof IOObject) {
                this.outExtender.deliver(Collections.singletonList((IOObject)result));
            } else {
                this.getLogger().warning("Unknown result: " + result.getClass() + ": " + result);
            }
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeText type = new ParameterTypeText(PARAMETER_SCRIPT, "The script to execute.", TextType.JAVA, false);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeBoolean(PARAMETER_STANDARD_IMPORTS, "Indicates if standard imports for examples and attributes etc. should be automatically generated.", true));
        return types;
    }
}

