/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.DummyPortPairExtender;
import com.rapidminer.operator.ports.PortPairExtender;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.parameter.ParameterTypeText;
import com.rapidminer.parameter.TextType;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.jdbc.DatabaseHandler;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;

public class SQLExecution
extends Operator {
    public static final String PARAMETER_QUERY = "query";
    public static final String PARAMETER_QUERY_FILE = "query_file";
    private PortPairExtender dummyPorts = new DummyPortPairExtender("through", this.getInputPorts(), this.getOutputPorts());

    public SQLExecution(OperatorDescription description) {
        super(description);
        this.dummyPorts.start();
        this.getTransformer().addRule(this.dummyPorts.makePassThroughRule());
    }

    @Override
    public void doWork() throws OperatorException {
        try {
            DatabaseHandler databaseHandler = DatabaseHandler.getConnectedDatabaseHandler(this);
            String query = this.getQuery();
            databaseHandler.executeStatement(query, false, this, this.getLogger());
            databaseHandler.disconnect();
        }
        catch (SQLException sqle) {
            throw new UserError((Operator)this, (Throwable)sqle, 304, sqle.getMessage());
        }
        this.dummyPorts.passDataThrough();
    }

    private String getQuery() throws OperatorException {
        String query = this.getParameterAsString(PARAMETER_QUERY);
        if (query != null) {
            query = query.trim();
        }
        String parameterUsed = null;
        boolean warning = false;
        if (query == null || query.length() == 0) {
            File queryFile = this.getParameterAsFile(PARAMETER_QUERY_FILE);
            if (queryFile != null) {
                try {
                    query = Tools.readTextFile(queryFile);
                    parameterUsed = PARAMETER_QUERY_FILE;
                }
                catch (IOException ioe) {
                    throw new UserError((Operator)this, (Throwable)ioe, 302, queryFile, ioe.getMessage());
                }
                if (query == null || query.trim().length() == 0) {
                    throw new UserError((Operator)this, 205, queryFile);
                }
            }
        } else {
            parameterUsed = PARAMETER_QUERY;
            if (this.isParameterSet(PARAMETER_QUERY_FILE)) {
                warning = true;
            }
        }
        if (query == null) {
            throw new UserError((Operator)this, 202, PARAMETER_QUERY, PARAMETER_QUERY_FILE);
        }
        if (warning) {
            this.logWarning("Only one of the parameters 'query' and 'query_file' has to be set. Using value of '" + parameterUsed + "'.");
        }
        return query;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.addAll(DatabaseHandler.getConnectionParameterTypes(this));
        ParameterTypeText type = new ParameterTypeText(PARAMETER_QUERY, "SQL query. If not set, the query is read from the file specified by 'query_file'.", TextType.SQL);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeFile(PARAMETER_QUERY_FILE, "File containing the query. Only evaluated if 'query' is not set.", null, true));
        types.addAll(DatabaseHandler.getStatementPreparationParamterTypes(this));
        return types;
    }
}

