/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.Process;
import com.rapidminer.ProcessContext;
import com.rapidminer.ProcessListener;
import com.rapidminer.RapidMiner;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.MissingIOObjectException;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.ResultObject;
import com.rapidminer.operator.SimpleProcessSetupError;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.OutputPortExtender;
import com.rapidminer.operator.ports.SinglePortExtender;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.SubprocessTransformRule;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import com.rapidminer.parameter.conditions.NonEqualTypeCondition;
import com.rapidminer.repository.Entry;
import com.rapidminer.repository.IOObjectEntry;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.RepositoryLocation;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.MailUtilities;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.io.Encoding;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class ProcessRootOperator
extends OperatorChain {
    public static final String PROPERTY_RAPIDMINER_GENERAL_RANDOMSEED = "rapidminer.general.randomseed";
    public static final String PARAMETER_ENCODING = "encoding";
    public static final String PARAMETER_LOGVERBOSITY = "logverbosity";
    public static final String PARAMETER_LOGFILE = "logfile";
    public static final String PARAMETER_RESULTFILE = "resultfile";
    public static final String PARAMETER_TEMP_DIR = "temp_dir";
    public static final String PARAMETER_DELETE_TEMP_FILES = "delete_temp_files";
    public static final String PARAMETER_RANDOM_SEED = "random_seed";
    public static final String PARAMETER_SEND_MAIL = "send_mail";
    public static final String[] PARAMETER_SEND_MAIL_OPTIONS = new String[]{"always", "never", "for_long_processes"};
    public static final int PARAMETER_SEND_MAIL_ALWAYS = 0;
    public static final int PARAMETER_SEND_MAIL_NEVER = 1;
    public static final int PARAMETER_SEND_MAIL_FOR_LONG = 2;
    public static final String PARAMETER_PROCESS_DURATION_FOR_MAIL = "process_duration_for_mail";
    public static final String PARAMETER_NOTIFICATION_EMAIL = "notification_email";
    private final List<ProcessListener> listenerList = new LinkedList<ProcessListener>();
    private Process process;
    private final SinglePortExtender<InputPort> resultPortExtender = new SinglePortExtender<InputPort>("result", this.getSubprocess(0).getInnerSinks());
    private final OutputPortExtender processInputExtender = new OutputPortExtender("input", this.getSubprocess(0).getInnerSources());

    public ProcessRootOperator(OperatorDescription description) {
        this(description, (Process)null);
        this.getTransformer().addRuleAtBeginning(new MDTransformationRule(){

            @Override
            public void transformMD() {
                if (ProcessRootOperator.this.getProcess() == null) {
                    return;
                }
                ProcessContext context = ProcessRootOperator.this.getProcess().getContext();
                if (ProcessRootOperator.this.getProcess().getProcessState() == 0) {
                    ProcessRootOperator.this.getProcess().applyContextMacros();
                }
                for (int i = 0; i < context.getInputRepositoryLocations().size(); ++i) {
                    RepositoryLocation loc;
                    String location = context.getInputRepositoryLocations().get(i);
                    if (location == null || location.length() <= 0 || i >= ProcessRootOperator.this.getSubprocess(0).getInnerSources().getNumberOfPorts()) continue;
                    OutputPort port = (OutputPort)ProcessRootOperator.this.getSubprocess(0).getInnerSources().getPortByIndex(i);
                    try {
                        loc = ProcessRootOperator.this.getProcess().resolveRepositoryLocation(location);
                    }
                    catch (Exception e1) {
                        ProcessRootOperator.this.addError(new SimpleProcessSetupError(ProcessSetupError.Severity.WARNING, ProcessRootOperator.this.getPortOwner(), "repository_access_error", location, e1.toString()));
                        return;
                    }
                    try {
                        Entry entry = loc.locateEntry();
                        if (entry == null) {
                            ProcessRootOperator.this.addError(new SimpleProcessSetupError(ProcessSetupError.Severity.WARNING, ProcessRootOperator.this.getPortOwner(), "repository_location_does_not_exist", location));
                            continue;
                        }
                        if (entry instanceof IOObjectEntry) {
                            port.deliverMD(((IOObjectEntry)entry).retrieveMetaData());
                            continue;
                        }
                        ProcessRootOperator.this.addError(new SimpleProcessSetupError(ProcessSetupError.Severity.WARNING, ProcessRootOperator.this.getPortOwner(), "repository_location_wrong_type", location, entry.getType(), "IOObject"));
                        continue;
                    }
                    catch (RepositoryException e) {
                        ProcessRootOperator.this.addError(new SimpleProcessSetupError(ProcessSetupError.Severity.WARNING, ProcessRootOperator.this.getPortOwner(), "repository_access_error", location, e.getMessage()));
                    }
                }
            }
        });
    }

    public ProcessRootOperator(OperatorDescription description, Process process) {
        super(description, "Main Process");
        this.resultPortExtender.start();
        this.processInputExtender.start();
        this.getTransformer().addRule(new SubprocessTransformRule(this.getSubprocess(0)));
        this.addValue(new ValueDouble("memory", "The current memory usage."){

            @Override
            public double getDoubleValue() {
                return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            }
        });
        this.setProcess(process);
        this.rename("Root");
    }

    public void deliverInput(List<IOObject> inputs) {
        this.processInputExtender.deliver(inputs);
    }

    public void deliverInputMD(List<MetaData> inputMD) {
        this.processInputExtender.deliverMetaData(inputMD);
    }

    public void setProcess(Process process) {
        this.process = process;
        this.registerOperator(this.process);
    }

    @Override
    public Process getProcess() {
        return this.process;
    }

    public void addProcessListener(ProcessListener l) {
        this.listenerList.add(l);
    }

    public void removeProcessListener(ProcessListener l) {
        this.listenerList.remove(l);
    }

    @Override
    public void processStarts() throws OperatorException {
        super.processStarts();
        Iterator<ProcessListener> i = this.listenerList.iterator();
        while (i.hasNext()) {
            i.next().processStarts(this.process);
        }
    }

    public void processStartedOperator(Operator op) {
        for (ProcessListener listener : this.listenerList) {
            listener.processStartedOperator(this.process, op);
        }
    }

    public void processFinishedOperator(Operator op) {
        for (ProcessListener listener : this.listenerList) {
            listener.processFinishedOperator(this.process, op);
        }
    }

    @Override
    public void processFinished() throws OperatorException {
        super.processFinished();
        Iterator<ProcessListener> i = this.listenerList.iterator();
        while (i.hasNext()) {
            i.next().processEnded(this.process);
        }
    }

    public void sendEmail(IOContainer results, Throwable e) throws UndefinedParameterError {
        String email;
        int sendEmail = this.getParameterAsInt(PARAMETER_SEND_MAIL);
        if (sendEmail == 1) {
            return;
        }
        if (sendEmail == 2) {
            long minTimeToSendEmail = this.getParameterAsInt(PARAMETER_PROCESS_DURATION_FOR_MAIL) * 60 * 1000;
            if (System.currentTimeMillis() - this.getStartTime() < minTimeToSendEmail) {
                return;
            }
        }
        if ((email = this.getParameterAsString(PARAMETER_NOTIFICATION_EMAIL)) == null) {
            return;
        }
        this.getLogger().info("Sending notification email to '" + email + "'");
        String name = email;
        int at = name.indexOf("@");
        if (at >= 0) {
            name = name.substring(0, at);
        }
        String subject = "Process " + this.getName() + " finished";
        StringBuilder content = new StringBuilder("Hello " + name + "," + Tools.getLineSeparator() + Tools.getLineSeparator());
        content.append("I'm sending you a notification message on your process '" + this.getProcess().getProcessLocation() + "'." + Tools.getLineSeparator());
        if (e != null) {
            content.append("Process failed: " + e.toString());
            subject = "Process " + this.getName() + " failed";
        }
        if (results != null) {
            content.append(Tools.getLineSeparator() + Tools.getLineSeparator() + "Results:");
            int i = 0;
            try {
                while (true) {
                    ResultObject result = results.get(ResultObject.class, i);
                    content.append(Tools.getLineSeparator() + Tools.getLineSeparator() + Tools.getLineSeparator() + result.toResultString());
                    ++i;
                }
            }
            catch (MissingIOObjectException exc) {
                // empty catch block
            }
        }
        MailUtilities.sendEmail(email, subject, content.toString());
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        int defaultTime;
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeCategory(PARAMETER_LOGVERBOSITY, "Log verbosity level.", LogService.LOG_VERBOSITY_NAMES, 3);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeFile(PARAMETER_LOGFILE, "File to write logging information to.", "log", true);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeFile(PARAMETER_RESULTFILE, "File to write inputs of the ResultWriter operators to.", "res", true));
        int seed = 2001;
        String seedProperty = System.getProperty(PROPERTY_RAPIDMINER_GENERAL_RANDOMSEED);
        try {
            if (seedProperty != null) {
                seed = Integer.parseInt(seedProperty);
            }
        }
        catch (NumberFormatException e) {
            this.logWarning("Bad integer in property 'rapidminer.general.randomseed', using default seed (2001).");
        }
        types.add(new ParameterTypeInt(PARAMETER_RANDOM_SEED, "Global random seed for random generators (-1 for initialization by system time).", Integer.MIN_VALUE, Integer.MAX_VALUE, seed));
        types.add(new ParameterTypeCategory(PARAMETER_SEND_MAIL, "Send email upon completion of the proces.", PARAMETER_SEND_MAIL_OPTIONS, 1));
        ParameterTypeString parameterRecepient = new ParameterTypeString(PARAMETER_NOTIFICATION_EMAIL, "Email address for the notification mail.", System.getProperty("rapidminer.tools.mail.default_recipient"));
        parameterRecepient.registerDependencyCondition(new NonEqualTypeCondition(this, PARAMETER_SEND_MAIL, PARAMETER_SEND_MAIL_OPTIONS, true, 1));
        types.add(parameterRecepient);
        try {
            defaultTime = Integer.parseInt(System.getProperty("rapidminer.tools.mail.process_duration_for_mail"));
        }
        catch (NumberFormatException e) {
            defaultTime = 30;
        }
        ParameterTypeInt parameterTimeMail = new ParameterTypeInt(PARAMETER_PROCESS_DURATION_FOR_MAIL, "Minimum process duration to send emails (in minutes).", 0, Integer.MAX_VALUE, defaultTime);
        parameterTimeMail.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_SEND_MAIL, PARAMETER_SEND_MAIL_OPTIONS, true, 2));
        types.add(parameterTimeMail);
        types.addAll(Encoding.getParameterTypes(this));
        return types;
    }

    public IOContainer getResults() {
        return this.getSubprocess(0).getInnerSinks().createIOContainer(false);
    }

    public List<MetaData> getResultMetaData() {
        LinkedList<MetaData> result = new LinkedList<MetaData>();
        for (InputPort resultPort : this.getSubprocess(0).getInnerSinks().getAllPorts()) {
            result.add(resultPort.getMetaData());
        }
        while (!result.isEmpty() && result.getLast() == null) {
            result.removeLast();
        }
        return result;
    }

    static {
        RapidMiner.registerRapidMinerProperty(new ParameterTypeInt(PROPERTY_RAPIDMINER_GENERAL_RANDOMSEED, "The default random seed (-1: random random seed).", -1, Integer.MAX_VALUE, 2001));
    }
}

