/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.tools.I18N;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class OperatorException
extends Exception {
    private static final long serialVersionUID = 3626738574540303240L;
    private static ResourceBundle messages = I18N.getErrorBundle();
    private static final MessageFormat formatter = new MessageFormat("");

    public OperatorException(String message) {
        super(message);
    }

    public OperatorException(String message, Throwable cause) {
        super(message, cause);
    }

    public OperatorException(String errorKey, Throwable cause, Object ... arguments) {
        super(OperatorException.getErrorMessage(errorKey, arguments), cause);
    }

    public static String getErrorMessage(String identifier, Object[] arguments) {
        String message = OperatorException.getResourceString(identifier, "short", "No message.");
        try {
            formatter.applyPattern(message);
            String formatted = formatter.format(arguments);
            return formatted;
        }
        catch (Throwable t) {
            return message;
        }
    }

    public static String getResourceString(String id, String key, String deflt) {
        if (messages == null) {
            return deflt;
        }
        try {
            return messages.getString("error." + id + "." + key);
        }
        catch (MissingResourceException e) {
            return deflt;
        }
    }
}

