/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.io.process.XMLTools;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.tools.GroupTree;
import com.rapidminer.tools.OperatorService;
import com.rapidminer.tools.XMLException;
import com.rapidminer.tools.documentation.OperatorDocBundle;
import com.rapidminer.tools.documentation.OperatorDocumentation;
import com.rapidminer.tools.plugin.Plugin;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ImageIcon;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OperatorDescription
implements Comparable<OperatorDescription> {
    private final String key;
    private final Class<? extends Operator> clazz;
    private List<String> replacesDeprecatedKeys;
    private final OperatorDocumentation documentation;
    private ImageIcon[] icons;
    private final String iconName;
    private final GroupTree groupTree;
    @Deprecated
    private final String deprecationInfo;
    private final Plugin provider;
    private boolean enabled = true;

    public OperatorDescription(GroupTree groupTree, Element element, ClassLoader classLoader, Plugin provider, OperatorDocBundle bundle) throws ClassNotFoundException, XMLException {
        this.deprecationInfo = null;
        this.provider = provider;
        this.groupTree = groupTree;
        this.key = XMLTools.getTagContents(element, "key", true);
        this.iconName = XMLTools.getTagContents(element, "icon");
        Class<?> generatedClass = Class.forName(XMLTools.getTagContents(element, "class", true).trim(), true, classLoader);
        this.clazz = generatedClass;
        this.documentation = (OperatorDocumentation)bundle.getObject("operator." + this.key);
        if (this.documentation.getName().equals("")) {
            this.documentation.setName(this.key);
            this.documentation.setDocumentation("Operator's description is missing in referenced OperatorDoc.");
        }
        groupTree.addOperatorDescription(this);
        this.loadIcons();
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!(child instanceof Element) || !((Element)child).getTagName().equals("replaces")) continue;
            this.setIsReplacementFor(((Element)child).getTextContent());
        }
    }

    public OperatorDescription(String key, Class<? extends Operator> clazz, GroupTree groupTree, ClassLoader classLoader, String iconName, Plugin provider) {
        this(key, clazz, groupTree, classLoader, iconName, provider, null);
    }

    public OperatorDescription(String key, Class<? extends Operator> clazz, GroupTree groupTree, ClassLoader classLoader, String iconName, Plugin provider, OperatorDocBundle bundle) {
        this.deprecationInfo = null;
        this.key = key;
        this.clazz = clazz;
        this.groupTree = groupTree;
        this.provider = provider;
        this.iconName = iconName;
        if (bundle == null) {
            this.documentation = new OperatorDocumentation(key);
        } else {
            this.documentation = (OperatorDocumentation)bundle.getObject("operator." + key);
            if (this.documentation.getName().equals("")) {
                this.documentation.setName(key);
                this.documentation.setDocumentation("Operator's description is missing in referenced OperatorDoc.");
            }
        }
        groupTree.addOperatorDescription(this);
        this.loadIcons();
    }

    @Deprecated
    public OperatorDescription(ClassLoader classLoader, String key, String name, String className, String group, String iconName, String deprecationInfo, Plugin provider) throws ClassNotFoundException {
        this(classLoader, key, name, className, null, null, group, iconName, deprecationInfo, provider);
    }

    @Deprecated
    public OperatorDescription(ClassLoader classLoader, String key, String name, String className, String shortDescription, String longDescription, String groupName, String iconName, String deprecationInfo, Plugin provider) throws ClassNotFoundException {
        this.deprecationInfo = null;
        this.key = key;
        this.iconName = iconName;
        this.clazz = Class.forName(className, true, classLoader);
        this.documentation = new OperatorDocumentation(name);
        this.documentation.setSynopsis(shortDescription);
        this.documentation.setDocumentation(longDescription);
        this.documentation.setDeprecation(deprecationInfo);
        this.groupTree = GroupTree.findGroup(groupName, null);
        this.groupTree.addOperatorDescription(this);
        this.provider = provider;
        this.loadIcons();
    }

    public String getName() {
        return this.getOperatorDocumentation().getName();
    }

    public String getShortName() {
        return this.getOperatorDocumentation().getShortName();
    }

    public Class<? extends Operator> getOperatorClass() {
        return this.clazz;
    }

    public String getShortDescription() {
        return this.getOperatorDocumentation().getSynopsis();
    }

    public String getLongDescriptionHTML() {
        return this.getOperatorDocumentation().getDocumentation();
    }

    public OperatorDocumentation getOperatorDocumentation() {
        return this.documentation;
    }

    public String getGroup() {
        return this.groupTree.getQName();
    }

    public String getGroupName() {
        return this.groupTree.getGroupName();
    }

    public ImageIcon getIcon() {
        return this.getIcons()[1];
    }

    public ImageIcon getSmallIcon() {
        ImageIcon[] icons2 = this.getIcons();
        if (icons2[0] != null) {
            return icons2[0];
        }
        return icons2[1];
    }

    public ImageIcon getLargeIcon() {
        ImageIcon[] icons2 = this.getIcons();
        if (icons2[2] != null) {
            return icons2[2];
        }
        return icons2[1];
    }

    public String getAbbreviatedClassName() {
        return this.getOperatorClass().getName().replace("com.rapidminer.operator.", "c.r.o.");
    }

    public String getDeprecationInfo() {
        if (this.deprecationInfo != null) {
            return this.deprecationInfo;
        }
        return this.getOperatorDocumentation().getDeprecation();
    }

    public boolean isDeprecated() {
        return this.deprecationInfo != null;
    }

    public String getProviderName() {
        return this.provider != null ? this.provider.getName() : "RapidMiner Core";
    }

    public String getProviderNamespace() {
        return this.provider != null ? this.provider.getExtensionId() : "core";
    }

    public String getKey() {
        if (this.provider != null) {
            return this.provider.getPrefix() + ":" + this.key;
        }
        return this.key;
    }

    public void disable() {
        this.enabled = false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String toString() {
        return "key='" + this.key + "'; name='" + this.getName() + "'; " + (this.replacesDeprecatedKeys != null ? "replaces: " + this.replacesDeprecatedKeys : "") + "; implemented by " + this.clazz.getName() + "; group: " + this.groupTree.getQName() + "; icon: " + this.iconName;
    }

    @Override
    public int compareTo(OperatorDescription d) {
        String myName = this.getName();
        String otherName = d.getName();
        return myName.compareTo(otherName);
    }

    public boolean equals(Object o) {
        if (!(o instanceof OperatorDescription)) {
            return false;
        }
        OperatorDescription other = (OperatorDescription)o;
        return this.getKey().equals(other.getKey());
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public Operator createOperatorInstance() throws OperatorCreationException {
        if (!this.isEnabled()) {
            throw new OperatorCreationException(6, this.key + "(" + this.clazz.getName() + ")", null);
        }
        Operator operator = null;
        try {
            Constructor<? extends Operator> constructor = this.clazz.getConstructor(OperatorDescription.class);
            operator = constructor.newInstance(this);
            if (this.getName().startsWith("W-")) {
                operator.getParameterTypes();
            }
        }
        catch (InstantiationException e) {
            throw new OperatorCreationException(0, this.key + "(" + this.clazz.getName() + ")", e);
        }
        catch (IllegalAccessException e) {
            throw new OperatorCreationException(1, this.key + "(" + this.clazz.getName() + ")", e);
        }
        catch (NoSuchMethodException e) {
            throw new OperatorCreationException(2, this.key + "(" + this.clazz.getName() + ")", e);
        }
        catch (InvocationTargetException e) {
            throw new OperatorCreationException(3, this.key + "(" + this.clazz.getName() + ")", e);
        }
        OperatorService.invokeCreationHooks(operator);
        return operator;
    }

    public void setIsReplacementFor(String opName) {
        if (this.replacesDeprecatedKeys == null) {
            this.replacesDeprecatedKeys = new LinkedList<String>();
        }
        this.replacesDeprecatedKeys.add(opName);
    }

    public List<String> getReplacedKeys() {
        if (this.replacesDeprecatedKeys != null) {
            return this.replacesDeprecatedKeys;
        }
        return Collections.emptyList();
    }

    public String getIconName() {
        if (this.iconName != null) {
            return this.iconName;
        }
        return this.groupTree.getIconName();
    }

    private void loadIcons() {
        if (this.iconName != null) {
            this.icons = new ImageIcon[3];
            this.icons[0] = SwingTools.createIcon("16/" + this.iconName);
            this.icons[1] = SwingTools.createIcon("24/" + this.iconName);
            this.icons[2] = SwingTools.createIcon("48/" + this.iconName);
        } else {
            this.icons = null;
        }
    }

    private ImageIcon[] getIcons() {
        if (this.icons != null) {
            return this.icons;
        }
        return this.groupTree.getIcons();
    }

    public Plugin getProvider() {
        return this.provider;
    }

    public GroupTree getGroupTree() {
        return this.groupTree;
    }
}

