/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.Process;
import com.rapidminer.operator.ExecutionUnit;
import com.rapidminer.operator.IllegalInputException;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.WrongNumberOfInnerOperatorsException;
import com.rapidminer.operator.condition.InnerOperatorCondition;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.metadata.Precondition;
import com.rapidminer.tools.DelegatingObserver;
import com.rapidminer.tools.Observer;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.patterns.Visitor;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public abstract class OperatorChain
extends Operator {
    private ExecutionUnit[] subprocesses;
    private final Observer<ExecutionUnit> delegatingObserver = new DelegatingObserver<ExecutionUnit, OperatorChain>(this, this);

    @Deprecated
    public OperatorChain(OperatorDescription description) {
        this(description, new String[0]);
    }

    public OperatorChain(OperatorDescription description, String ... subprocessNames) {
        super(description);
        this.subprocesses = new ExecutionUnit[subprocessNames.length];
        for (int i = 0; i < this.subprocesses.length; ++i) {
            this.subprocesses[i] = new ExecutionUnit(this, subprocessNames[i]);
            this.subprocesses[i].addObserver(this.delegatingObserver, false);
            this.makeDirtyOnUpdate(this.subprocesses[i].getInnerSinks());
        }
    }

    public boolean areSubprocessesExtendable() {
        return false;
    }

    public ExecutionUnit removeSubprocess(int index) {
        ExecutionUnit deleted = this.subprocesses[index];
        ExecutionUnit[] copy = this.subprocesses;
        this.subprocesses = new ExecutionUnit[copy.length - 1];
        int j = 0;
        for (int i = 0; i < copy.length; ++i) {
            if (i == index) continue;
            this.subprocesses[j++] = copy[i];
        }
        this.fireUpdate(this);
        return deleted;
    }

    public ExecutionUnit addSubprocess(int index) {
        ExecutionUnit[] copy = this.subprocesses;
        this.subprocesses = new ExecutionUnit[copy.length + 1];
        int j = 0;
        for (int i = 0; i < copy.length; ++i) {
            if (i == index) {
                // empty if block
            }
            int n = ++j;
            ++j;
            this.subprocesses[n] = copy[i];
        }
        this.subprocesses[index] = this.createSubprocess(index);
        this.fireUpdate(this);
        return this.subprocesses[index];
    }

    protected ExecutionUnit createSubprocess(int index) {
        return new ExecutionUnit(this, "Subprocess");
    }

    @Deprecated
    public int getMaxNumberOfInnerOperators() {
        return 0;
    }

    @Deprecated
    public int getMinNumberOfInnerOperators() {
        return 0;
    }

    @Deprecated
    public InnerOperatorCondition getInnerOperatorCondition() {
        return null;
    }

    @Override
    public Operator cloneOperator(String name, boolean forParallelExcecution) {
        OperatorChain clone = (OperatorChain)super.cloneOperator(name, forParallelExcecution);
        if (this.areSubprocessesExtendable()) {
            while (clone.getNumberOfSubprocesses() < this.getNumberOfSubprocesses()) {
                clone.addSubprocess(clone.getNumberOfSubprocesses());
            }
        }
        for (int i = 0; i < this.subprocesses.length; ++i) {
            clone.subprocesses[i].cloneExecutionUnitFrom(this.subprocesses[i], forParallelExcecution);
        }
        return clone;
    }

    @Override
    @Deprecated
    public Class<?>[] checkIO(Class<?>[] input) throws IllegalInputException, WrongNumberOfInnerOperatorsException {
        this.getLogger().warning("As of RM 5.0, checkIO() is no longer necessary.");
        return input;
    }

    @Deprecated
    protected boolean shouldReturnInnerOutput() {
        return false;
    }

    protected boolean shouldAddNonConsumedInput() {
        return !this.shouldReturnInnerOutput();
    }

    @Deprecated
    public final int addOperator(Operator o) {
        for (ExecutionUnit process : this.subprocesses) {
            if (process.getNumberOfOperators() != 0) continue;
            process.addOperator(o);
            this.getLogger().warning("OperatorChain.addOperator() is deprecated! Use getSubprocess(int).addOperator(). I have added the operator to subprocess " + process.getName());
        }
        throw new UnsupportedOperationException("addOperator() is no longer supported. Failed to guess which subprocess was intended. Try getSubprocess(int).addOperator()");
    }

    public final int addOperator(Operator operator, int index) {
        if (index < this.subprocesses.length) {
            this.subprocesses[index].addOperator(operator);
            this.getLogger().warning("OperatorChain.addOperator() is deprecated! Use getSubprocess(int).addOperator(). I have added the operator to subprocess " + this.subprocesses[index].getName());
            return index;
        }
        throw new UnsupportedOperationException("addOperator() is no longer supported. Try getSubprocess(int).addOperator()");
    }

    @Override
    protected void registerOperator(Process process) {
        super.registerOperator(process);
        for (ExecutionUnit subprocess : this.subprocesses) {
            for (Operator child : subprocess.getOperators()) {
                child.registerOperator(process);
            }
        }
    }

    @Override
    protected void unregisterOperator(Process process) {
        super.unregisterOperator(process);
        for (ExecutionUnit subprocess : this.subprocesses) {
            for (Operator child : subprocess.getOperators()) {
                child.unregisterOperator(process);
            }
        }
    }

    @Deprecated
    protected final void removeOperator(Operator operator) {
        throw new UnsupportedOperationException("removeOperator is deprecated. Use getSubprocess(int).removeOperator()");
    }

    @Deprecated
    public Operator getOperator(int i) {
        throw new UnsupportedOperationException("getOperator(int) is deprecated. Try getSubprocess(int).");
    }

    @Deprecated
    public Iterator<Operator> getOperators() {
        throw new UnsupportedOperationException("OperatorChain.getNumberOfOperators() is deprecated. Try getSubprocesses(int).getOperators()");
    }

    public List<Operator> getImmediateChildren() {
        LinkedList<Operator> children = new LinkedList<Operator>();
        for (ExecutionUnit executionUnit : this.subprocesses) {
            children.addAll(executionUnit.getOperators());
        }
        return children;
    }

    public List<Operator> getAllInnerOperators() {
        LinkedList<Operator> children = new LinkedList<Operator>();
        for (ExecutionUnit executionUnit : this.subprocesses) {
            children.addAll(executionUnit.getAllInnerOperators());
        }
        return children;
    }

    public List<Operator> getAllInnerOperatorsAndMe() {
        List<Operator> children = this.getAllInnerOperators();
        children.add(this);
        return children;
    }

    @Deprecated
    public int getNumberOfOperators() {
        return this.subprocesses.length;
    }

    @Deprecated
    public int getNumberOfAllOperators() {
        return this.subprocesses.length;
    }

    @Deprecated
    public Operator getOperatorFromAll(int i) {
        throw new UnsupportedOperationException("OperatorChain.getOperatorFromAll(int) is deprecated. Try getSubprocess(int).getOperators()");
    }

    @Deprecated
    public int getIndexOfOperator(Operator operator, boolean useDisabled) {
        throw new UnsupportedOperationException("OperatorChain.getOperatorFromAll(int) is deprecated. Try getSubprocess(int).getOperators()");
    }

    @Override
    public boolean isEnabled() {
        if (this.getParent() == null) {
            return super.isEnabled();
        }
        return super.isEnabled() && this.getParent().isEnabled();
    }

    @Override
    public void processStarts() throws OperatorException {
        super.processStarts();
        for (ExecutionUnit unit : this.subprocesses) {
            unit.processStarts();
        }
    }

    @Override
    public void processFinished() throws OperatorException {
        super.processFinished();
        for (ExecutionUnit unit : this.subprocesses) {
            unit.processFinished();
        }
    }

    @Override
    public void doWork() throws OperatorException {
        for (ExecutionUnit subprocess : this.subprocesses) {
            subprocess.getInnerSinks().clear(4);
            subprocess.execute();
        }
    }

    @Override
    public void freeMemory() {
        super.freeMemory();
        for (ExecutionUnit unit : this.subprocesses) {
            unit.freeMemory();
        }
    }

    @Override
    protected void performAdditionalChecks() {
        super.performAdditionalChecks();
        for (ExecutionUnit subprocess : this.subprocesses) {
            for (Operator o : subprocess.getOperators()) {
                if (!o.isEnabled()) continue;
                o.performAdditionalChecks();
            }
        }
    }

    @Override
    public int checkProperties() {
        int errorCount = super.checkProperties();
        for (ExecutionUnit subprocess : this.subprocesses) {
            for (Operator o : subprocess.getOperators()) {
                if (!o.isEnabled()) continue;
                errorCount += o.checkProperties();
            }
        }
        return errorCount;
    }

    @Override
    public int checkDeprecations() {
        int deprecationCount = super.checkDeprecations();
        for (ExecutionUnit subprocess : this.subprocesses) {
            for (Operator o : subprocess.getOperators()) {
                deprecationCount += o.checkDeprecations();
            }
        }
        return deprecationCount;
    }

    @Deprecated
    public int checkNumberOfInnerOperators() {
        return 0;
    }

    @Override
    protected String createProcessTree(int indent, String selfPrefix, String childPrefix, Operator markOperator, String mark) {
        String tree = super.createProcessTree(indent, selfPrefix, childPrefix, markOperator, mark);
        for (int i = 0; i < this.subprocesses.length; ++i) {
            tree = tree + Tools.getLineSeparator() + this.subprocesses[i].createProcessTree(indent, childPrefix + "+- ", childPrefix + (i < this.subprocesses.length - 1 ? "|  " : "   "), markOperator, mark);
        }
        return tree;
    }

    public ExecutionUnit getSubprocess(int index) {
        return this.subprocesses[index];
    }

    public int getNumberOfSubprocesses() {
        return this.subprocesses.length;
    }

    public List<ExecutionUnit> getSubprocesses() {
        return Arrays.asList(this.subprocesses);
    }

    @Override
    protected void collectErrors(List<ProcessSetupError> errors) {
        super.collectErrors(errors);
        for (ExecutionUnit executionUnit : this.subprocesses) {
            for (Operator op : executionUnit.getOperators()) {
                op.collectErrors(errors);
            }
            for (Port port : executionUnit.getInnerSinks().getAllPorts()) {
                errors.addAll(port.getErrors());
            }
            for (Port port : executionUnit.getInnerSources().getAllPorts()) {
                errors.addAll(port.getErrors());
            }
        }
    }

    @Override
    public void clear(int clearFlags) {
        super.clear(clearFlags);
        for (ExecutionUnit executionUnit : this.subprocesses) {
            executionUnit.clear(clearFlags);
        }
    }

    @Override
    public void assumePreconditionsSatisfied() {
        super.assumePreconditionsSatisfied();
        for (ExecutionUnit executionUnit : this.subprocesses) {
            for (InputPort inputPort : executionUnit.getInnerSinks().getAllPorts()) {
                for (Precondition precondition : inputPort.getAllPreconditions()) {
                    precondition.assumeSatisfied();
                }
            }
        }
    }

    @Override
    public void notifyRenaming(String oldName, String newName) {
        for (ExecutionUnit subprocess : this.subprocesses) {
            for (Operator child : subprocess.getOperators()) {
                child.notifyRenaming(oldName, newName);
            }
        }
        this.getParameters().notifyRenaming(oldName, newName);
    }

    @Override
    protected void propagateDirtyness() {
        for (ExecutionUnit unit : this.subprocesses) {
            for (Operator op : unit.getOperators()) {
                op.propagateDirtyness();
            }
        }
    }

    @Override
    public void updateExecutionOrder() {
        for (ExecutionUnit unit : this.subprocesses) {
            unit.updateExecutionOrder();
        }
    }

    @Override
    protected Operator lookupOperator(String operatorName) {
        Operator result = super.lookupOperator(operatorName);
        if (result != null) {
            return result;
        }
        for (Operator child : this.getAllInnerOperators()) {
            if (!child.getName().equals(operatorName)) continue;
            return child;
        }
        return null;
    }

    @Override
    public void walk(Visitor<Operator> visitor) {
        super.walk(visitor);
        for (ExecutionUnit unit : this.subprocesses) {
            for (Operator op : unit.getOperators()) {
                op.walk(visitor);
            }
        }
    }
}

