/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.BreakpointListener;
import com.rapidminer.Process;
import com.rapidminer.gui.tools.VersionNumber;
import com.rapidminer.gui.wizards.ConfigurationListener;
import com.rapidminer.gui.wizards.PreviewListener;
import com.rapidminer.io.process.XMLExporter;
import com.rapidminer.io.process.XMLImporter;
import com.rapidminer.io.process.XMLTools;
import com.rapidminer.operator.DebugMode;
import com.rapidminer.operator.DefaultIODescription;
import com.rapidminer.operator.ExecutionMode;
import com.rapidminer.operator.ExecutionUnit;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IODescription;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.IOObjectCollection;
import com.rapidminer.operator.IllegalInputException;
import com.rapidminer.operator.InputDescription;
import com.rapidminer.operator.MissingIOObjectException;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.OperatorVersion;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.ProcessStoppedException;
import com.rapidminer.operator.SimpleProcessSetupError;
import com.rapidminer.operator.UnknownParameterInformation;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.Value;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.WrongNumberOfInnerOperatorsException;
import com.rapidminer.operator.annotation.ResourceConsumer;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.InputPorts;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.OutputPorts;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.PortOwner;
import com.rapidminer.operator.ports.Ports;
import com.rapidminer.operator.ports.impl.InputPortsImpl;
import com.rapidminer.operator.ports.impl.OutputPortsImpl;
import com.rapidminer.operator.ports.metadata.CompatibilityLevel;
import com.rapidminer.operator.ports.metadata.MDTransformer;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.MetaDataError;
import com.rapidminer.operator.ports.metadata.Precondition;
import com.rapidminer.operator.ports.quickfix.ParameterSettingQuickFix;
import com.rapidminer.operator.ports.quickfix.QuickFix;
import com.rapidminer.operator.ports.quickfix.RelativizeRepositoryLocationQuickfix;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeColor;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeRepositoryLocation;
import com.rapidminer.parameter.ParameterTypeTupel;
import com.rapidminer.parameter.Parameters;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.repository.MalformedRepositoryLocationException;
import com.rapidminer.repository.RepositoryLocation;
import com.rapidminer.tools.AbstractObservable;
import com.rapidminer.tools.DelegatingObserver;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.LoggingHandler;
import com.rapidminer.tools.Observable;
import com.rapidminer.tools.Observer;
import com.rapidminer.tools.ProgressListener;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.WrapperLoggingHandler;
import com.rapidminer.tools.XMLException;
import com.rapidminer.tools.math.StringToMatrixConverter;
import com.rapidminer.tools.patterns.Visitor;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class Operator
extends AbstractObservable<Operator>
implements ConfigurationListener,
PreviewListener,
LoggingHandler,
ParameterHandler,
ResourceConsumer {
    private static final OperatorVersion[] EMPTY_OPERATOR_VERSIONS_ARRAY = new OperatorVersion[0];
    private boolean[] breakPoint = new boolean[BreakpointListener.BREAKPOINT_POS_NAME.length];
    private boolean enabled = true;
    private boolean expanded = true;
    private String name;
    private String userDescription;
    private AtomicInteger applyCount = new AtomicInteger();
    private int applyCountAtLastExecution = -1;
    private long startTime;
    private long startCpuTime;
    private long endTime;
    private long endCpuTime;
    private long loopStartTime;
    private Parameters parameters = null;
    private final Map<String, Value> valueMap = new TreeMap<String, Value>();
    private List<ProcessSetupError> errorList = Collections.synchronizedList(new LinkedList());
    private OperatorDescription operatorDescription = null;
    private boolean dirty = true;
    private boolean dirtynessWasPropagated = false;
    private final transient Logger logger = Logger.getLogger(Operator.class.getName());
    private final transient LoggingHandler logService = new WrapperLoggingHandler(this.logger);
    private boolean isRunning = false;
    private boolean shouldStopStandaloneExecution = false;
    private OperatorVersion compatibilityLevel;
    private final PortOwner portOwner = new PortOwner(){

        @Override
        public OperatorChain getPortHandler() {
            return Operator.this.getParent();
        }

        @Override
        public String getName() {
            return Operator.this.getName();
        }

        @Override
        public Operator getOperator() {
            return Operator.this;
        }

        @Override
        public ExecutionUnit getConnectionContext() {
            return Operator.this.getExecutionUnit();
        }
    };
    private final InputPorts inputPorts = new InputPortsImpl(this.portOwner);
    private final OutputPorts outputPorts = new OutputPortsImpl(this.portOwner);
    private final MDTransformer transformer = new MDTransformer(this);
    private final Observer<Port> delegatingPortObserver = new DelegatingObserver<Port, Operator>(this, this);
    private final Observer<String> delegatingParameterObserver = new DelegatingObserver<String, Operator>(this, this);
    private final Observer dirtyObserver = new Observer<Object>(){

        @Override
        public void update(Observable<Object> observable, Object arg) {
            Operator.this.makeDirty();
        }
    };
    private ExecutionUnit enclosingExecutionUnit;

    public Operator(OperatorDescription description) {
        this.operatorDescription = description;
        this.parameters = null;
        this.name = this.operatorDescription.getOperatorDocumentation().getShortName();
        this.inputPorts.addObserver(this.delegatingPortObserver, false);
        this.outputPorts.addObserver(this.delegatingPortObserver, false);
        this.makeDirtyOnUpdate(this.inputPorts);
        this.addValue(new ValueDouble("applycount", "The number of times the operator was applied.", false){

            @Override
            public double getDoubleValue() {
                return Operator.this.applyCountAtLastExecution;
            }
        });
        this.addValue(new ValueDouble("time", "The time elapsed since this operator started.", false){

            @Override
            public double getDoubleValue() {
                return System.currentTimeMillis() - Operator.this.startTime;
            }
        });
        this.addValue(new ValueDouble("cpu-time", "The cpu time elapsed since this operator started.", false){

            @Override
            public double getDoubleValue() {
                return ManagementFactory.getThreadMXBean().getThreadCpuTime(Thread.currentThread().getId()) - Operator.this.startCpuTime;
            }
        });
        this.addValue(new ValueDouble("execution-time", "The execution time of this operator.", false){

            @Override
            public double getDoubleValue() {
                return Operator.this.endTime - Operator.this.startTime;
            }
        });
        this.addValue(new ValueDouble("cpu-execution-time", "The cpu execution time of this operator.", false){

            @Override
            public double getDoubleValue() {
                return Operator.this.endCpuTime - Operator.this.startCpuTime;
            }
        });
        this.addValue(new ValueDouble("looptime", "The time elapsed since the current loop started.", false){

            @Override
            public double getDoubleValue() {
                return System.currentTimeMillis() - Operator.this.loopStartTime;
            }
        });
    }

    protected void makeDirtyOnUpdate(Observable<? extends Object> observable) {
        observable.addObserver(this.dirtyObserver, false);
    }

    public final OperatorDescription getOperatorDescription() {
        return this.operatorDescription;
    }

    public final String getOperatorClassName() {
        return this.operatorDescription.getName();
    }

    @Deprecated
    public Process getExperiment() {
        return this.getProcess();
    }

    @Override
    public Process getProcess() {
        OperatorChain parent = this.getParent();
        if (parent == null) {
            return null;
        }
        return parent.getProcess();
    }

    public LoggingHandler getLog() {
        return this.logService;
    }

    public Logger getLogger() {
        if (this.getProcess() == null) {
            return this.logger;
        }
        return this.getProcess().getLogger();
    }

    @Override
    public void log(String message, int level) {
        this.getLog().log(message, level);
    }

    @Override
    public void log(String message) {
        this.getLogger().fine(this.getName() + ": " + message);
    }

    @Override
    public void logNote(String message) {
        this.getLog().log(this.getName() + ": " + message, 4);
    }

    @Override
    public void logWarning(String message) {
        this.getLog().log(this.getName() + ": " + message, 5);
    }

    @Override
    public void logError(String message) {
        this.getLog().log(this.getName() + ": " + message, 6);
    }

    public final String getName() {
        return this.name;
    }

    private final void setName(String newName) {
        this.name = newName;
    }

    public final String rename(String newName) {
        Process process = this.getProcess();
        if (process != null) {
            process.unregisterName(this.name);
            String oldName = this.name;
            this.name = process.registerName(newName, this);
            process.notifyRenaming(oldName, this.name);
        } else {
            this.name = newName;
        }
        this.fireUpdate(this);
        return this.name;
    }

    public void setUserDescription(String description) {
        this.userDescription = description;
        this.fireUpdate(this);
    }

    public String getUserDescription() {
        return this.userDescription;
    }

    @Deprecated
    public final String getDeprecationInfo() {
        return this.operatorDescription.getDeprecationInfo();
    }

    public void removeAndKeepConnections(List<Operator> keepConnectionsTo) {
        this.getInputPorts().disconnectAllBut(keepConnectionsTo);
        this.getOutputPorts().disconnectAllBut(keepConnectionsTo);
        Process process = this.getProcess();
        if (this.enclosingExecutionUnit != null) {
            this.enclosingExecutionUnit.removeOperator(this);
        }
        if (process != null) {
            this.unregisterOperator(process);
        }
    }

    public void remove() {
        this.removeAndKeepConnections(null);
    }

    @Deprecated
    public void register(Process process, String name) {
    }

    protected void registerOperator(Process process) {
        if (process != null) {
            this.setName(process.registerName(this.getName(), this));
        }
    }

    protected void unregisterOperator(Process process) {
        process.unregisterName(this.name);
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled != enabled) {
            this.enabled = enabled;
            this.fireUpdate(this);
        }
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public boolean isEnabled() {
        if (this.getParent() == null) {
            return this.enabled;
        }
        return this.enabled && this.getParent().isEnabled();
    }

    public boolean isParallel() {
        return false;
    }

    public int getApplyCount() {
        return this.applyCountAtLastExecution;
    }

    public Operator cloneOperator(String name, boolean forParallelExecution) {
        Operator clone = null;
        try {
            clone = this.operatorDescription.createOperatorInstance();
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Can not create clone of operator '" + this.getName() + "': " + e, e);
            throw new RuntimeException("Can not create clone of operator '" + this.getName(), e);
        }
        clone.setName(this.getName());
        clone.breakPoint = new boolean[]{this.breakPoint[0], this.breakPoint[1]};
        clone.enabled = this.enabled;
        clone.expanded = this.expanded;
        if (this.userDescription != null) {
            clone.userDescription = this.userDescription;
        }
        clone.applyCount = forParallelExecution ? this.applyCount : new AtomicInteger();
        clone.startTime = this.startTime;
        clone.startCpuTime = this.startCpuTime;
        clone.endTime = this.endTime;
        clone.endCpuTime = this.endCpuTime;
        clone.loopStartTime = this.loopStartTime;
        clone.getParameters().copyFrom(this.getParameters());
        clone.errorList = this.errorList;
        return clone;
    }

    @Deprecated
    public IOObject[] apply() throws OperatorException {
        throw new UnsupportedOperationException("apply() is depreaced. Implement doWork().");
    }

    public void doWork() throws OperatorException {
    }

    @Deprecated
    public Class<?>[] getInputClasses() {
        return new Class[0];
    }

    @Deprecated
    public Class<?>[] getOutputClasses() {
        return new Class[0];
    }

    protected final Class<?>[] getDesiredInputClasses() {
        Class<?>[] inputClasses = this.getInputClasses();
        if (inputClasses == null) {
            return new Class[0];
        }
        return inputClasses;
    }

    protected final Class<?>[] getDeliveredOutputClasses() {
        LinkedList result = new LinkedList();
        Class<?>[] inputClasses = this.getDesiredInputClasses();
        for (int i = 0; i < inputClasses.length; ++i) {
            InputDescription description = this.getInputDescription(inputClasses[i]);
            if ((!description.showParameter() || !this.getParameterAsBoolean(description.getParameterName())) && !description.getKeepDefault()) continue;
            result.add(inputClasses[i]);
        }
        Class<?>[] additionalOutput = this.getOutputClasses();
        if (additionalOutput != null) {
            for (int i = 0; i < additionalOutput.length; ++i) {
                result.add(additionalOutput[i]);
            }
        }
        Class[] resultArray = new Class[result.size()];
        result.toArray(resultArray);
        return resultArray;
    }

    @Deprecated
    protected InputDescription getInputDescription(Class<?> inputClass) {
        return new InputDescription(inputClass);
    }

    @Deprecated
    protected IODescription getIODescription() {
        return new DefaultIODescription(this.getDesiredInputClasses(), this.getDeliveredOutputClasses());
    }

    @Deprecated
    public Class<?>[] checkIO(Class<?>[] input) throws IllegalInputException, WrongNumberOfInnerOperatorsException {
        if (this.isEnabled()) {
            return this.getIODescription().getOutputClasses(input, this);
        }
        return input;
    }

    protected void performAdditionalChecks() {
    }

    public int checkProperties() {
        int errorCount = 0;
        if (this.isEnabled()) {
            for (ParameterType type : this.getParameters().getParameterTypes()) {
                String value;
                if (!type.isOptional() && type.getDefaultValue() == null && !this.getParameters().isSet(type.getKey())) {
                    this.addError(new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, this.portOwner, Collections.singletonList(new ParameterSettingQuickFix(this, type.getKey())), "undefined_parameter", type.getKey().replace('_', ' ')));
                    ++errorCount;
                }
                if (!(type instanceof ParameterTypeRepositoryLocation) || (value = this.getParameters().getParameterOrNull(type.getKey())) == null) continue;
                if (value.startsWith("//")) {
                    if (value.startsWith("//Samples")) continue;
                    this.addError(new SimpleProcessSetupError(ProcessSetupError.Severity.WARNING, this.portOwner, Collections.emptyList(), "accessing_repository_by_name", type.getKey().replace('_', ' '), value));
                    continue;
                }
                if (!value.startsWith(String.valueOf('/'))) continue;
                this.addError(new SimpleProcessSetupError(ProcessSetupError.Severity.WARNING, this.portOwner, Collections.singletonList(new RelativizeRepositoryLocationQuickfix(this, type.getKey(), value)), "absolute_repository_location", type.getKey().replace('_', ' '), value));
            }
        }
        return errorCount;
    }

    public int checkDeprecations() {
        String deprecationString = this.getOperatorDescription().getDeprecationInfo();
        int deprecationCount = 0;
        if (deprecationString != null) {
            this.addError(new SimpleProcessSetupError(ProcessSetupError.Severity.WARNING, this.portOwner, "deprecation", this.getOperatorDescription().getName(), deprecationString));
            deprecationCount = 1;
        }
        return deprecationCount;
    }

    @Deprecated
    public final IOContainer apply(IOContainer input) throws OperatorException {
        throw new UnsupportedOperationException("apply(IOContainer) is deprecated. Use execute()!");
    }

    public final void execute() throws OperatorException {
        Process process = this.getProcess();
        if (process == null) {
            this.getLogger().fine("Process of operator " + this.getName() + " is not set, probably not registered! Trying to use this operator (should work in most cases anyway)...");
        }
        if (process != null && process.getExecutionMode() == ExecutionMode.ONLY_DIRTY && !this.isDirty()) {
            return;
        }
        if (this.getOperatorDescription().getDeprecationInfo() != null && this.applyCount.get() == 0) {
            this.getLogger().warning("Deprecation warning for " + this.getOperatorDescription().getName() + ": " + this.getOperatorDescription().getDeprecationInfo());
        }
        this.getOutputPorts().clear(4);
        if (this.isEnabled()) {
            StringBuilder builder;
            this.checkForStop(process);
            this.applyCountAtLastExecution = this.applyCount.incrementAndGet();
            this.startTime = this.loopStartTime = System.currentTimeMillis();
            this.startCpuTime = ManagementFactory.getThreadMXBean().getThreadCpuTime(Thread.currentThread().getId());
            if (process != null) {
                process.setCurrentOperator(this);
                process.getRootOperator().processStartedOperator(this);
            }
            if (this.breakPoint[0]) {
                this.processBreakpoint(this.getInputPorts().createIOContainer(true), 0);
            }
            for (InputPort inputPort : this.getInputPorts().getAllPorts()) {
                Object ioObject = inputPort.getDataOrNull();
                if (ioObject == null) continue;
                ioObject.setLoggingHandler(this.getLog());
            }
            this.getLogger().fine("Starting application " + this.applyCount + " of operator " + this.getName());
            if (this.getLogger().isLoggable(WrapperLoggingHandler.LEVELS[1])) {
                builder = new StringBuilder();
                builder.append(this.getName());
                builder.append(" called ");
                builder.append(Tools.ordinalNumber(this.applyCount.get()));
                builder.append(" time with input:");
                this.formatIO(this.getInputPorts(), builder);
                this.getLogger().log(WrapperLoggingHandler.LEVELS[1], builder.toString());
            }
            this.getOutputPorts().clear(4);
            try {
                this.isRunning = true;
                this.fireUpdate();
                this.doWork();
                this.getLogger().fine("Completed application " + this.applyCount.get() + " of operator " + this.getName());
            }
            catch (UserError e) {
                if (e.getOperator() == null) {
                    e.setOperator(this);
                }
                throw e;
            }
            finally {
                this.isRunning = false;
                this.endTime = System.currentTimeMillis();
                this.endCpuTime = ManagementFactory.getThreadMXBean().getThreadCpuTime(Thread.currentThread().getId());
                for (OutputPort outputPort : this.getOutputPorts().getAllPorts()) {
                    Object ioObject = outputPort.getDataOrNull();
                    if (ioObject == null || ioObject.getSource() != null) continue;
                    ioObject.setSource(this.getName());
                    if (ioObject instanceof IOObjectCollection) {
                        for (IOObject ioo : ((IOObjectCollection)ioObject).getObjects()) {
                            if (ioo.getSource() != null) continue;
                            ioo.setSource(this.getName());
                        }
                    }
                    ioObject.setLoggingHandler(null);
                }
            }
            if (this.getLogger().isLoggable(WrapperLoggingHandler.LEVELS[1])) {
                builder = new StringBuilder(this.getName());
                builder.append(" returned with output:");
                this.formatIO(this.getOutputPorts(), builder);
                this.getLogger().log(WrapperLoggingHandler.LEVELS[1], builder.toString());
            }
            this.getLogger().finest(this.getName() + ": execution time was " + (System.currentTimeMillis() - this.startTime) + " ms");
            if (process != null) {
                process.getRootOperator().processFinishedOperator(this);
            }
            if (this.breakPoint[1]) {
                this.processBreakpoint(this.getOutputPorts().createIOContainer(true), 1);
            }
        }
        this.setNotDirty();
    }

    private void formatIO(Ports<? extends Port> ports, StringBuilder builder) {
        for (Port port : ports.getAllPorts()) {
            builder.append("\n  ");
            builder.append(port.getName());
            IOObject data = port.getAnyDataOrNull();
            builder.append(data == null ? "-/-" : data.toString());
        }
    }

    public final void checkForStop() throws ProcessStoppedException {
        if (this.getParent() != null) {
            this.checkForStop(this.getParent().getProcess());
        } else {
            this.checkForStop(this.getProcess());
        }
    }

    private final void checkForStop(Process process) throws ProcessStoppedException {
        if (process != null && process.shouldStop()) {
            this.stop();
            return;
        }
        if (process != null && process.shouldPause()) {
            this.getLogger().info("Process interrupted in " + this.getName());
            this.processBreakpoint(null, 1);
        }
        if (process == null && this.shouldStopStandaloneExecution) {
            this.stop();
            return;
        }
    }

    public final void shouldStopStandaloneExecution() throws ProcessStoppedException {
        if (this.getProcess() == null) {
            this.shouldStopStandaloneExecution = true;
        }
    }

    private final void stop() throws ProcessStoppedException {
        this.getLogger().info(this.getName() + ": Process stopped.");
        throw new ProcessStoppedException(this);
    }

    @Deprecated
    public final void resume() {
        this.getProcess().resume();
    }

    private void processBreakpoint(IOContainer container, int breakpointType) throws ProcessStoppedException {
        this.getLogger().info(this.getName() + ": Breakpoint reached.");
        Process process = this.getProcess();
        process.pause(this, container, breakpointType);
        if (process.shouldStop()) {
            this.stop();
        }
    }

    @Deprecated
    public boolean getAddOnlyAdditionalOutput() {
        return false;
    }

    @Deprecated
    protected <T extends IOObject> T getInput(Class<T> cls) throws MissingIOObjectException {
        return this.getInput(cls, 0);
    }

    @Deprecated
    protected <T extends IOObject> T getInput(Class<T> cls, int nr) throws MissingIOObjectException {
        int successCount = 0;
        for (InputPort inputPort : this.getInputPorts().getAllPorts()) {
            IOObject input = inputPort.getAnyDataOrNull();
            if (input == null || !cls.isAssignableFrom(input.getClass())) continue;
            if (successCount == nr) {
                return (T)input;
            }
            ++successCount;
        }
        throw new MissingIOObjectException(cls);
    }

    @Deprecated
    protected boolean hasInput(Class<? extends IOObject> cls) {
        try {
            this.getInput(cls);
            return true;
        }
        catch (MissingIOObjectException e) {
            return false;
        }
    }

    @Deprecated
    protected final IOContainer getInput() {
        throw new UnsupportedOperationException("getInput() is deprecated. Use the input ports.");
    }

    @Deprecated
    protected void setInput(IOContainer input) {
        throw new UnsupportedOperationException("setInput() is deprecated. Use the input ports.");
    }

    public void processStarts() throws OperatorException {
        this.applyCount.set(0);
        this.applyCountAtLastExecution = 0;
    }

    public void processFinished() throws OperatorException {
    }

    public void setBreakpoint(int position, boolean on) {
        this.breakPoint[position] = on;
        this.fireUpdate(this);
    }

    public boolean hasBreakpoint() {
        return this.hasBreakpoint(0) || this.hasBreakpoint(1);
    }

    public boolean hasBreakpoint(int position) {
        return this.breakPoint[position];
    }

    public void inApplyLoop() throws ProcessStoppedException {
        this.loopStartTime = System.currentTimeMillis();
        this.checkForStop();
    }

    public void addValue(Value value) {
        this.valueMap.put(value.getKey(), value);
    }

    public final Value getValue(String key) {
        return this.valueMap.get(key);
    }

    public Collection<Value> getValues() {
        return this.valueMap.values();
    }

    @Override
    public Parameters getParameters() {
        if (this.parameters == null) {
            this.parameters = new Parameters(this.getParameterTypes());
            this.parameters.addObserver(this.delegatingParameterObserver, false);
            this.makeDirtyOnUpdate(this.parameters);
        }
        return this.parameters;
    }

    @Override
    public ParameterHandler getParameterHandler() {
        return this;
    }

    @Override
    public void setParameters(Parameters parameters) {
        this.parameters = parameters;
    }

    @Override
    public void setParameter(String key, String value) {
        this.getParameters().setParameter(key, value);
    }

    @Override
    public void setListParameter(String key, List<String[]> list) {
        this.getParameters().setParameter(key, ParameterTypeList.transformList2String(list));
    }

    public void setPairParameter(String key, String firstValue, String secondValue) {
        this.getParameters().setParameter(key, ParameterTypeTupel.transformTupel2String(firstValue, secondValue));
    }

    @Override
    public String getParameter(String key) throws UndefinedParameterError {
        try {
            return this.expandString(this.replaceMacros(this.getParameters().getParameter(key), this.getParameters().getParameterType(key)));
        }
        catch (UndefinedParameterError e) {
            e.setOperator(this);
            throw e;
        }
    }

    @Override
    public boolean isParameterSet(String key) {
        return this.getParameters().isSet(key);
    }

    @Override
    public String getParameterAsString(String key) throws UndefinedParameterError {
        return this.getParameter(key);
    }

    @Override
    public char getParameterAsChar(String key) throws UndefinedParameterError {
        String parameterValue = this.getParameter(key);
        if (parameterValue.length() > 0) {
            return parameterValue.charAt(0);
        }
        return '\u0000';
    }

    @Override
    public int getParameterAsInt(String key) throws UndefinedParameterError {
        ParameterType type = this.getParameters().getParameterType(key);
        String value = this.getParameter(key);
        if (type != null && type instanceof ParameterTypeCategory) {
            String parameterValue = value;
            try {
                return Integer.valueOf(parameterValue);
            }
            catch (NumberFormatException e) {
                ParameterTypeCategory categoryType = (ParameterTypeCategory)type;
                return categoryType.getIndex(parameterValue);
            }
        }
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new UndefinedParameterError(key, "Expected integer but found '" + value + "'.");
        }
    }

    @Override
    public double getParameterAsDouble(String key) throws UndefinedParameterError {
        String value = this.getParameter(key);
        try {
            return Double.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new UndefinedParameterError(key, "Expected real number but found '" + value + "'.");
        }
    }

    @Override
    public boolean getParameterAsBoolean(String key) {
        try {
            return Boolean.valueOf(this.getParameter(key));
        }
        catch (UndefinedParameterError undefinedParameterError) {
            return false;
        }
    }

    @Override
    public List<String[]> getParameterList(String key) throws UndefinedParameterError {
        return ParameterTypeList.transformString2List(this.getParameter(key));
    }

    @Override
    public String[] getParameterTupel(String key) throws UndefinedParameterError {
        return ParameterTypeTupel.transformString2Tupel(this.getParameter(key));
    }

    @Override
    public Color getParameterAsColor(String key) throws UndefinedParameterError {
        return ParameterTypeColor.string2Color(this.getParameter(key));
    }

    @Override
    public InputStream getParameterAsInputStream(String key) throws UndefinedParameterError, IOException {
        String urlString = this.getParameter(key);
        if (urlString == null) {
            return null;
        }
        try {
            URL url = new URL(urlString);
            InputStream stream = url.openStream();
            return stream;
        }
        catch (MalformedURLException e) {
            File file = this.getParameterAsFile(key);
            if (file != null) {
                return new FileInputStream(file);
            }
            return null;
        }
    }

    @Override
    public File getParameterAsFile(String key) throws UndefinedParameterError {
        return this.getParameterAsFile(key, false);
    }

    @Override
    public File getParameterAsFile(String key, boolean createMissingDirectories) throws UndefinedParameterError {
        String fileName = this.getParameter(key);
        if (fileName == null) {
            return null;
        }
        Process process = this.getProcess();
        if (process != null) {
            File result = process.resolveFileName(fileName);
            if (createMissingDirectories) {
                if (result.isDirectory()) {
                    result.mkdirs();
                } else {
                    File parent = result.getParentFile();
                    if (parent != null) {
                        parent.mkdirs();
                    }
                }
            }
            return result;
        }
        this.getLogger().warning(this.getName() + " is not attached to a process. Trying '" + fileName + "' as absolute filename.");
        File result = new File(fileName);
        if (createMissingDirectories) {
            if (result.isDirectory()) {
                result.mkdirs();
            } else {
                File parent = result.getParentFile();
                if (parent != null) {
                    parent.mkdirs();
                }
            }
        }
        return result;
    }

    public RepositoryLocation getParameterAsRepositoryLocation(String key) throws UserError {
        String loc = this.getParameter(key);
        Process process = this.getProcess();
        if (process != null) {
            RepositoryLocation result;
            try {
                result = process.resolveRepositoryLocation(loc);
            }
            catch (MalformedRepositoryLocationException e) {
                throw new UserError(this, (Throwable)e, 319, e.getMessage());
            }
            result.setAccessor(process.getRepositoryAccessor());
            return result;
        }
        if (RepositoryLocation.isAbsolute(loc)) {
            RepositoryLocation result;
            try {
                result = new RepositoryLocation(loc);
            }
            catch (MalformedRepositoryLocationException e) {
                throw new UserError(this, (Throwable)e, 319, e.getMessage());
            }
            return result;
        }
        throw new UserError(this, 320, loc);
    }

    @Override
    public double[][] getParameterAsMatrix(String key) throws UndefinedParameterError {
        String matrixLine = this.getParameter(key);
        try {
            return StringToMatrixConverter.parseMatlabString(matrixLine);
        }
        catch (OperatorException e) {
            throw new UndefinedParameterError(e.getMessage(), this);
        }
    }

    private String expandString(String str) {
        if (str == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        int totalStart = 0;
        int start = 0;
        while ((start = str.indexOf("%{", totalStart)) >= 0) {
            result.append(str.substring(totalStart, start));
            int end = str.indexOf(125, start);
            if (end >= start) {
                int closeNumberIndex;
                int openNumberIndex;
                String command = str.substring(start + 2, end);
                if ("n".equals(command)) {
                    result.append(this.getName());
                } else if ("c".equals(command)) {
                    result.append(this.getClass().getName());
                } else if ("a".equals(command)) {
                    result.append(this.applyCount);
                } else if ("b".equals(command)) {
                    result.append(this.applyCount.get() + 1);
                } else if (command.startsWith("p[")) {
                    openNumberIndex = command.indexOf(91, 3);
                    if (openNumberIndex < 0) {
                        throw new RuntimeException("A number in [] must follow %p, for example $p[10].");
                    }
                    closeNumberIndex = command.indexOf(93, openNumberIndex);
                    if (closeNumberIndex < 0) {
                        throw new RuntimeException("A number in [] must follow %p, for example $p[10].");
                    }
                    if (closeNumberIndex <= openNumberIndex + 1) {
                        throw new RuntimeException("A number in [] must follow %p, for example $p[10].");
                    }
                    String numberString = command.substring(openNumberIndex + 1, closeNumberIndex);
                    int number = Integer.parseInt(numberString);
                    result.append(this.applyCount.get() + number);
                } else if ("t".equals(command)) {
                    GregorianCalendar calendar = new GregorianCalendar();
                    result.append(calendar.get(1) + "_");
                    String month = calendar.get(2) + 1 + "";
                    if (month.length() < 2) {
                        month = "0" + month;
                    }
                    result.append(month + "_");
                    String day = calendar.get(5) + "";
                    if (day.length() < 2) {
                        day = "0" + day;
                    }
                    result.append(day + "-");
                    int amPm = calendar.get(9);
                    String amPmString = amPm == 0 ? "AM" : "PM";
                    result.append(amPmString + "_");
                    String hour = calendar.get(10) + "";
                    if (hour.length() < 2) {
                        hour = "0" + hour;
                    }
                    result.append(hour + "_");
                    String minute = calendar.get(12) + "";
                    if (minute.length() < 2) {
                        minute = "0" + minute;
                    }
                    result.append(minute + "_");
                    String second = calendar.get(13) + "";
                    if (second.length() < 2) {
                        second = "0" + second;
                    }
                    result.append(second);
                } else if ("v[".equals(command)) {
                    openNumberIndex = command.indexOf(91, 3);
                    if (openNumberIndex < 0) {
                        throw new RuntimeException("An operator name and a value name divided by '.' in [] must follow $v, for example $p[Learner.applycount].");
                    }
                    closeNumberIndex = command.indexOf(93, openNumberIndex);
                    if (closeNumberIndex < 0) {
                        throw new RuntimeException("An operator name and a value name divided by '.' in [] must follow $v, for example $p[Learner.applycount].");
                    }
                    if (closeNumberIndex <= openNumberIndex + 1) {
                        throw new RuntimeException("An operator name and a value name divided by '.' in [] must follow $v, for example $p[Learner.applycount].");
                    }
                    String operatorValueString = command.substring(openNumberIndex + 1, closeNumberIndex);
                    String[] operatorValuePair = operatorValueString.split("\\.");
                    if (operatorValuePair.length != 2) {
                        throw new RuntimeException("An operator name and a value name divided by '.' in [] must follow $v, for example $p[Learner.applycount].");
                    }
                    Operator operator = this.lookupOperator(operatorValuePair[0]);
                    Value value = operator.getValue(operatorValuePair[1]);
                    if (value == null) {
                        this.logError("Value '" + operatorValuePair[1] + "' of the operator '" + operatorValuePair[0] + "' not found!");
                    } else if (value.isNominal()) {
                        Object valueObject = value.getValue();
                        if (valueObject != null) {
                            result.append(valueObject.toString());
                        } else {
                            this.logError("Value '" + operatorValuePair[1] + "' of the operator '" + operatorValuePair[0] + "' not found!");
                        }
                    } else {
                        double doubleValue = (Double)value.getValue();
                        if (!Double.isNaN(doubleValue)) {
                            result.append(Tools.formatIntegerIfPossible(doubleValue));
                        } else {
                            this.logError("Value '" + operatorValuePair[1] + "' of the operator '" + operatorValuePair[0] + "' not found!");
                        }
                    }
                } else if ("%".equals(command)) {
                    result.append('%');
                } else {
                    result.append(command);
                }
            } else {
                end = start + 2;
                result.append("%{");
            }
            totalStart = end + 1;
        }
        result.append(str.substring(totalStart));
        return result.toString();
    }

    private String replaceMacros(String value, ParameterType parameterType) {
        if (value == null) {
            return null;
        }
        if (parameterType == null || this.getProcess() == null) {
            try {
                String line = value;
                int startIndex = line.indexOf("%{");
                StringBuffer result = new StringBuffer();
                while (startIndex >= 0) {
                    result.append(line.substring(0, startIndex));
                    int endIndex = line.indexOf("}", startIndex + 2);
                    String macroString = line.substring(startIndex + 2, endIndex);
                    String macroValue = this.getProcess().getMacroHandler().getMacro(macroString);
                    if (macroValue != null) {
                        result.append(macroValue);
                    } else {
                        result.append("%{" + macroString + "}");
                    }
                    line = line.substring(endIndex + 1);
                    startIndex = line.indexOf("%{");
                }
                result.append(line);
                return result.toString();
            }
            catch (Exception e) {
                return value;
            }
        }
        return parameterType.substituteMacros(value, this.getProcess().getMacroHandler());
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        Class<?>[] inputClasses = this.getDesiredInputClasses();
        for (int i = 0; i < inputClasses.length; ++i) {
            InputDescription description = this.getInputDescription(inputClasses[i]);
            if (!description.showParameter()) continue;
            types.add(new ParameterTypeBoolean(description.getParameterName(), "Indicates if this input object should also be returned as output.", description.getKeepDefault()));
        }
        return types;
    }

    public ParameterType getParameterType(String name) {
        for (ParameterType current : this.getParameters().getParameterTypes()) {
            if (!current.getKey().equals(name)) continue;
            return current;
        }
        return null;
    }

    @Deprecated
    public void writeXML(Writer out, String indent, boolean hideDefault) throws IOException {
        this.writeXML(out, hideDefault);
    }

    public void writeXML(Writer out, boolean hideDefault) throws IOException {
        try {
            XMLTools.stream(new XMLExporter().exportProcess(this, hideDefault), new StreamResult(out), XMLImporter.PROCESS_FILE_CHARSET);
        }
        catch (XMLException e) {
            throw new IOException("Cannot create process XML: " + e, e);
        }
    }

    public Document getDOMRepresentation() throws IOException {
        return new XMLExporter().exportProcess(this, false);
    }

    @Deprecated
    public String getXML(String indent, boolean hideDefault) {
        return this.getXML(hideDefault);
    }

    public String getXML(boolean hideDefault) {
        return this.getXML(hideDefault, false);
    }

    public String getXML(boolean hideDefault, boolean onlyCoreElements) {
        try {
            return XMLTools.toString(new XMLExporter(onlyCoreElements).exportProcess(this, hideDefault), XMLImporter.PROCESS_FILE_CHARSET);
        }
        catch (Exception e) {
            LogService.getRoot().log(Level.WARNING, "Cannot generate process XML: " + e, e);
            return e.toString();
        }
    }

    public static Operator createFromXML(Element element, Process targetProcess, List<UnknownParameterInformation> unknownParameterInformation) throws XMLException {
        return Operator.createFromXML(element, targetProcess, unknownParameterInformation, null);
    }

    public static Operator createFromXML(Element element, Process process, List<UnknownParameterInformation> unknownParameterInformation, ProgressListener l) throws XMLException {
        XMLImporter importer = new XMLImporter(l);
        return importer.parseOperator(element, XMLImporter.CURRENT_VERSION, process, unknownParameterInformation);
    }

    public static Operator createFromXML(Element element, Process process, List<UnknownParameterInformation> unknownParameterInformation, ProgressListener progressListener, VersionNumber originatingVersion) throws XMLException {
        XMLImporter importer = new XMLImporter(progressListener);
        return importer.parseOperator(element, originatingVersion, process, unknownParameterInformation);
    }

    public void clearErrorList() {
        this.clear(1);
    }

    private final void checkOperator() {
        if (!this.isEnabled()) {
            return;
        }
        this.checkProperties();
        this.checkDeprecations();
        this.performAdditionalChecks();
    }

    public void checkAll() {
        this.getRoot().clear(11);
        if (this.isEnabled()) {
            this.checkOperator();
            this.getRoot().transformMetaData();
            this.propagateDirtyness();
        }
        this.updateExecutionOrder();
    }

    public void checkAllExcludingMetaData() {
        this.getRoot().clear(10);
        if (this.isEnabled()) {
            this.checkOperator();
            this.propagateDirtyness();
        }
        this.updateExecutionOrder();
    }

    public void updateExecutionOrder() {
    }

    public void addError(ProcessSetupError error) {
        this.errorList.add(error);
    }

    @Deprecated
    public void addError(final String message) {
        this.errorList.add(new ProcessSetupError(){

            @Override
            public String getMessage() {
                return message;
            }

            @Override
            public PortOwner getOwner() {
                return Operator.this.portOwner;
            }

            public List<QuickFix> getQuickFixes() {
                return Collections.emptyList();
            }

            @Override
            public ProcessSetupError.Severity getSeverity() {
                return ProcessSetupError.Severity.ERROR;
            }
        });
    }

    @Deprecated
    public void addWarning(final String message) {
        this.errorList.add(new ProcessSetupError(){

            @Override
            public String getMessage() {
                return message;
            }

            @Override
            public PortOwner getOwner() {
                return Operator.this.portOwner;
            }

            public List<QuickFix> getQuickFixes() {
                return Collections.emptyList();
            }

            @Override
            public ProcessSetupError.Severity getSeverity() {
                return ProcessSetupError.Severity.WARNING;
            }
        });
    }

    public List<ProcessSetupError> getErrorList() {
        LinkedList<ProcessSetupError> errors = new LinkedList<ProcessSetupError>();
        this.collectErrors(errors);
        return errors;
    }

    protected void collectErrors(List<ProcessSetupError> errors) {
        Collection<MetaDataError> portErrors;
        errors.addAll(this.errorList);
        for (Port port : this.getInputPorts().getAllPorts()) {
            portErrors = port.getErrors();
            if (portErrors == null) continue;
            try {
                errors.addAll(portErrors);
            }
            catch (NullPointerException e) {}
        }
        for (Port port : this.getOutputPorts().getAllPorts()) {
            portErrors = port.getErrors();
            if (portErrors == null) continue;
            errors.addAll(port.getErrors());
        }
    }

    public long getStartTime() {
        return this.startTime;
    }

    public String toString() {
        String type = null;
        type = this.getOperatorDescription() != null ? this.getOperatorClassName() : this.getClass().getName();
        return (this.breakPoint[0] || this.breakPoint[1] ? "* " : "") + this.name + " (" + type + ")";
    }

    @Deprecated
    public String createExperimentTree(int indent) {
        return this.createProcessTree(indent);
    }

    public String createProcessTree(int indent) {
        return this.createProcessTree(indent, "", "", null, null);
    }

    @Deprecated
    public String createMarkedExperimentTree(int indent, String mark, Operator markOperator) {
        return this.createMarkedProcessTree(indent, mark, markOperator);
    }

    public String createMarkedProcessTree(int indent, String mark, Operator markOperator) {
        return this.createProcessTree(indent, "", "", markOperator, mark);
    }

    @Deprecated
    protected String createExperimentTree(int indent, String selfPrefix, String childPrefix, Operator markOperator, String mark) {
        return this.createProcessTree(indent, selfPrefix, childPrefix, markOperator, mark);
    }

    protected String createProcessTree(int indent, String selfPrefix, String childPrefix, Operator markOperator, String mark) {
        if (markOperator != null && this.getName().equals(markOperator.getName())) {
            return Tools.indent(indent - mark.length()) + mark + selfPrefix + this.getName() + "[" + this.applyCount + "]" + " (" + this.getOperatorClassName() + ")";
        }
        return Tools.indent(indent) + selfPrefix + this.getName() + "[" + this.applyCount + "]" + " (" + this.getOperatorClassName() + ")";
    }

    @Deprecated
    public final Charset getEncoding() {
        Process process = this.getProcess();
        if (process != null) {
            if (process.getRootOperator().isParameterSet("encoding")) {
                try {
                    return Process.getEncoding(process.getRootOperator().getParameterAsString("encoding"));
                }
                catch (UndefinedParameterError e) {
                    return Process.getEncoding(null);
                }
            }
            return Process.getEncoding(null);
        }
        return Process.getEncoding(null);
    }

    public boolean isDebugMode() {
        String debugProperty = System.getProperty("rapidminer.general.debugmode");
        return Tools.booleanValue(debugProperty, false);
    }

    public final OperatorChain getParent() {
        if (this.enclosingExecutionUnit != null) {
            return this.enclosingExecutionUnit.getEnclosingOperator();
        }
        return null;
    }

    public final InputPorts getInputPorts() {
        return this.inputPorts;
    }

    public final OutputPorts getOutputPorts() {
        return this.outputPorts;
    }

    protected final MDTransformer getTransformer() {
        return this.transformer;
    }

    public final ExecutionUnit getExecutionUnit() {
        return this.enclosingExecutionUnit;
    }

    protected final void setEnclosingProcess(ExecutionUnit parent) {
        if (parent != null && this.enclosingExecutionUnit != null) {
            throw new IllegalStateException("Parent already set.");
        }
        this.enclosingExecutionUnit = parent;
    }

    public void clear(int clearFlags) {
        if ((clearFlags & 8) > 0) {
            this.errorList.clear();
        }
        this.getInputPorts().clear(clearFlags);
        this.getOutputPorts().clear(clearFlags);
    }

    public void assumePreconditionsSatisfied() {
        for (InputPort inputPort : this.getInputPorts().getAllPorts()) {
            for (Precondition precondition : inputPort.getAllPreconditions()) {
                precondition.assumeSatisfied();
            }
        }
    }

    public void disconnectPorts() {
        for (Port port : this.getOutputPorts().getAllPorts()) {
            if (!port.isConnected()) continue;
            port.disconnect();
        }
        for (Port port : this.getInputPorts().getAllPorts()) {
            if (!port.isConnected()) continue;
            port.getSource().disconnect();
        }
    }

    public void transformMetaData() {
        this.clear(1);
        if (!this.isEnabled()) {
            return;
        }
        this.getInputPorts().checkPreconditions();
        this.getTransformer().transformMetaData();
    }

    public boolean shouldAutoConnect(OutputPort outputPort) {
        return true;
    }

    public boolean shouldAutoConnect(InputPort inputPort) {
        return true;
    }

    public Operator getRoot() {
        if (this.getParent() == null) {
            return this;
        }
        return this.getParent().getRoot();
    }

    public void notifyRenaming(String oldName, String newName) {
        this.getParameters().notifyRenaming(oldName, newName);
    }

    @Override
    protected void fireUpdate(Operator operator) {
        super.fireUpdate(operator);
        if (this.getProcess() != null) {
            this.getProcess().fireOperatorChanged(this);
        }
    }

    public void makeDirty() {
        if (!this.dirty) {
            this.dirty = true;
            if (this.getProcess().getDebugMode() == DebugMode.COLLECT_METADATA_AFTER_EXECUTION) {
                this.clear(16);
            }
            this.dirtynessWasPropagated = false;
            this.fireUpdate();
        }
    }

    protected void propagateDirtyness() {
        if (this.isDirty() && !this.dirtynessWasPropagated) {
            this.dirtynessWasPropagated = true;
            for (OutputPort port : this.getOutputPorts().getAllPorts()) {
                if (!port.isConnected()) continue;
                Operator operator = port.getDestination().getPorts().getOwner().getOperator();
                operator.makeDirty();
                operator.propagateDirtyness();
            }
        }
    }

    private void setNotDirty() {
        this.dirty = false;
        this.fireUpdate();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public int getNumberOfBreakpoints() {
        int num = 0;
        for (boolean bp : this.breakPoint) {
            if (!bp) continue;
            ++num;
        }
        return num;
    }

    public boolean acceptsInput(Class<? extends IOObject> inputClass) {
        MetaData metaData = new MetaData(inputClass);
        for (InputPort inPort : this.getInputPorts().getAllPorts()) {
            if (!inPort.isInputCompatible(metaData, CompatibilityLevel.PRE_VERSION_5)) continue;
            return true;
        }
        return false;
    }

    public boolean producesOutput(Class<? extends IOObject> outputClass) {
        this.assumePreconditionsSatisfied();
        this.transformMetaData();
        for (OutputPort outPort : this.getOutputPorts().getAllPorts()) {
            if (outPort.getMetaData() == null || !outputClass.isAssignableFrom(outPort.getMetaData().getObjectClass())) continue;
            return true;
        }
        return false;
    }

    public PortOwner getPortOwner() {
        return this.portOwner;
    }

    protected LinkedList<OutputPort> preAutoWire(LinkedList<OutputPort> readyOutputs) throws OperatorException {
        return readyOutputs;
    }

    public void freeMemory() {
        this.getInputPorts().freeMemory();
        this.getOutputPorts().freeMemory();
    }

    protected Operator lookupOperator(String operatorName) {
        if (this.getName().equals(operatorName)) {
            return this;
        }
        ExecutionUnit executionUnit = this.getExecutionUnit();
        if (executionUnit == null) {
            return null;
        }
        for (Operator sibling : executionUnit.getAllInnerOperators()) {
            if (!sibling.getName().equals(operatorName)) continue;
            return sibling;
        }
        OperatorChain parent = this.getParent();
        if (parent != null) {
            return parent.lookupOperator(operatorName);
        }
        return null;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void setCompatibilityLevel(OperatorVersion compatibilityLevel) {
        this.compatibilityLevel = compatibilityLevel;
        this.fireUpdate();
    }

    public OperatorVersion getCompatibilityLevel() {
        if (this.compatibilityLevel == null) {
            this.compatibilityLevel = OperatorVersion.getLatestVersion(this.getOperatorDescription());
        }
        return this.compatibilityLevel;
    }

    public OperatorVersion[] getIncompatibleVersionChanges() {
        return EMPTY_OPERATOR_VERSIONS_ARRAY;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return null;
    }

    public void walk(Visitor<Operator> visitor) {
        visitor.visit(this);
    }
}

