/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;

public class ModelUpdater
extends Operator {
    private InputPort exampleSetInput = this.getInputPorts().createPort("example set", ExampleSet.class);
    private InputPort modelInput = this.getInputPorts().createPort("model", Model.class);
    private OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set");
    private OutputPort modelOutput = (OutputPort)this.getOutputPorts().createPort("model");

    public ModelUpdater(OperatorDescription description) {
        super(description);
        this.getTransformer().addPassThroughRule(this.exampleSetInput, this.exampleSetOutput);
        this.getTransformer().addPassThroughRule(this.modelInput, this.modelOutput);
    }

    @Override
    public void doWork() throws OperatorException {
        ExampleSet inputExampleSet = (ExampleSet)this.exampleSetInput.getData();
        Model model = (Model)this.modelInput.getData();
        if (!model.isUpdatable()) {
            throw new UserError((Operator)this, 135, model.getClass());
        }
        try {
            model.updateModel(inputExampleSet);
        }
        catch (UserError e) {
            if (e.getOperator() == null) {
                e.setOperator(this);
            }
            throw e;
        }
        this.exampleSetOutput.deliver(inputExampleSet);
        this.modelOutput.deliver(model);
    }
}

