/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.operator.GroupedModel;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.IOObjectCollection;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.CollectionMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.GenerateNewMDRule;
import com.rapidminer.operator.ports.metadata.ModelMetaData;

public class ModelUngrouper
extends Operator {
    private InputPort groupedModelInput = this.getInputPorts().createPort("grouped model", GroupedModel.class);
    private OutputPort modelOutput = (OutputPort)this.getOutputPorts().createPort("models");

    public ModelUngrouper(OperatorDescription description) {
        super(description);
        this.getTransformer().addRule(new GenerateNewMDRule(this.modelOutput, new CollectionMetaData(new ModelMetaData(Model.class, new ExampleSetMetaData()))));
    }

    @Override
    public void doWork() throws OperatorException {
        GroupedModel groupedModel = (GroupedModel)this.groupedModelInput.getData();
        IOObject[] result = new Model[groupedModel.getNumberOfModels()];
        int index = 0;
        for (Model inner : groupedModel) {
            result[index++] = inner;
        }
        this.modelOutput.deliver(new IOObjectCollection(result));
    }
}

