/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.operator.GroupedModel;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.InputPortExtender;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.ModelMetaData;
import com.rapidminer.operator.ports.metadata.Precondition;
import com.rapidminer.operator.ports.metadata.SimplePrecondition;
import java.util.List;

public class ModelGrouper
extends Operator {
    private final InputPortExtender modelInputExtender = new InputPortExtender("models in", this.getInputPorts()){

        @Override
        protected Precondition makePrecondition(InputPort port) {
            int index = ModelGrouper.this.modelInputExtender.getManagedPorts().size();
            return new SimplePrecondition(port, new MetaData(Model.class), index < 2);
        }
    };
    private final OutputPort modelOutput = (OutputPort)this.getOutputPorts().createPort("model out");

    public ModelGrouper(OperatorDescription description) {
        super(description);
        this.modelInputExtender.ensureMinimumNumberOfPorts(2);
        this.getTransformer().addRule(new MDTransformationRule(){

            @Override
            public void transformMD() {
                MetaData input;
                List<MetaData> metaDatas = ModelGrouper.this.modelInputExtender.getMetaData(true);
                if (!metaDatas.isEmpty() && (input = metaDatas.iterator().next()) != null && input instanceof ModelMetaData) {
                    ExampleSetMetaData trainMD = ((ModelMetaData)input).getTrainingSetMetaData();
                    if (trainMD != null) {
                        ModelMetaData mmd = new ModelMetaData(GroupedModel.class, trainMD);
                        mmd.addToHistory(ModelGrouper.this.modelOutput);
                        ModelGrouper.this.modelOutput.deliverMD(mmd);
                        return;
                    }
                    ModelGrouper.this.modelOutput.deliverMD(null);
                    return;
                }
            }
        });
        this.modelInputExtender.start();
    }

    @Override
    public void doWork() throws OperatorException {
        GroupedModel groupedModel = new GroupedModel();
        List modelList = this.modelInputExtender.getData(true);
        for (Model model : modelList) {
            groupedModel.addModel(model);
        }
        this.modelOutput.deliver(groupedModel);
    }
}

