/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.ModelApplicationRule;
import com.rapidminer.operator.ports.metadata.ModelMetaData;
import com.rapidminer.operator.ports.metadata.PassThroughRule;
import com.rapidminer.operator.ports.metadata.SimplePrecondition;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.List;

public class ModelApplier
extends Operator {
    public static final String PARAMETER_KEY = "key";
    public static final String PARAMETER_APPLICATION_PARAMETERS = "application_parameters";
    private static final String PARAMETER_CREATE_VIEW = "create_view";
    private final InputPort modelInput = (InputPort)this.getInputPorts().createPort("model");
    private final InputPort exampleSetInput = (InputPort)this.getInputPorts().createPort("unlabelled data");
    private final OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("labelled data");
    private final OutputPort modelOutput = (OutputPort)this.getOutputPorts().createPort("model");

    public ModelApplier(OperatorDescription description) {
        super(description);
        this.modelInput.addPrecondition(new SimplePrecondition(this.modelInput, new ModelMetaData(Model.class, new ExampleSetMetaData())));
        this.exampleSetInput.addPrecondition(new SimplePrecondition(this.exampleSetInput, new ExampleSetMetaData()));
        this.getTransformer().addRule(new ModelApplicationRule(this.exampleSetInput, this.exampleSetOutput, this.modelInput, false));
        this.getTransformer().addRule(new PassThroughRule(this.modelInput, this.modelOutput, false));
    }

    @Override
    public void doWork() throws OperatorException {
        ExampleSet inputExampleSet = (ExampleSet)this.exampleSetInput.getData();
        Model model = (Model)this.modelInput.getData();
        this.log("Set parameters for " + model.getClass().getName());
        List<String[]> modelParameters = this.getParameterList(PARAMETER_APPLICATION_PARAMETERS);
        for (String[] parameter : modelParameters) {
            model.setParameter(parameter[0], parameter[1]);
        }
        if (this.getParameterAsBoolean(PARAMETER_CREATE_VIEW)) {
            model.setParameter(PARAMETER_CREATE_VIEW, true);
        }
        this.log("Applying " + model.getClass().getName());
        ExampleSet result = inputExampleSet;
        try {
            result = model.apply(inputExampleSet);
        }
        catch (UserError e) {
            if (e.getOperator() == null) {
                e.setOperator(this);
            }
            throw e;
        }
        this.exampleSetOutput.deliver(result);
        this.modelOutput.deliver(model);
    }

    @Override
    public boolean shouldAutoConnect(OutputPort port) {
        if (port == this.modelOutput) {
            return this.getParameterAsBoolean("keep_model");
        }
        return super.shouldAutoConnect(port);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeList(PARAMETER_APPLICATION_PARAMETERS, "Model parameters for application (usually not needed).", (ParameterType)new ParameterTypeString(PARAMETER_KEY, "The model parameter key."), (ParameterType)new ParameterTypeString(PARAMETER_KEY, "This key's value")));
        types.add(new ParameterTypeBoolean(PARAMETER_CREATE_VIEW, "Indicates that models should create a new view on the data where possible. Then, instead of changing the data itself, the results are calculated on the fly if needed.", false));
        return types;
    }
}

