/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.DummyPortPairExtender;
import com.rapidminer.operator.ports.PortPairExtender;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.List;

public class MacroDefinitionOperator
extends Operator {
    public static final String PARAMETER_VALUES = "values";
    public static final String PARAMETER_MACROS = "macros";
    private PortPairExtender dummyPorts = new DummyPortPairExtender("through", this.getInputPorts(), this.getOutputPorts());

    public MacroDefinitionOperator(OperatorDescription description) {
        super(description);
        this.dummyPorts.start();
        this.getTransformer().addRule(this.dummyPorts.makePassThroughRule());
    }

    @Override
    public void doWork() throws OperatorException {
        List<String[]> macros = this.getParameterList(PARAMETER_MACROS);
        for (String[] macroDefinition : macros) {
            String macro = macroDefinition[0];
            String value = macroDefinition[1];
            this.getProcess().getMacroHandler().addMacro(macro, value);
        }
        this.dummyPorts.passDataThrough();
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeList(PARAMETER_MACROS, "The list of macros defined by the user.", (ParameterType)new ParameterTypeString("macro_name", "The macro name."), (ParameterType)new ParameterTypeString(PARAMETER_VALUES, "The value of this macro.", false), false));
        return types;
    }
}

