/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.generator.GenerationException;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.DummyPortPairExtender;
import com.rapidminer.operator.ports.PortPairExtender;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.tools.math.function.ExpressionParser;
import java.util.List;

public class MacroConstructionOperator
extends Operator {
    public static final String PARAMETER_FUNCTIONS = "function_descriptions";
    public static final String PARAMETER_USE_STANDARD_CONSTANTS = "use_standard_constants";
    private PortPairExtender dummyPorts = new DummyPortPairExtender("through", this.getInputPorts(), this.getOutputPorts());

    public MacroConstructionOperator(OperatorDescription description) {
        super(description);
        this.dummyPorts.start();
        this.getTransformer().addRule(this.dummyPorts.makePassThroughRule());
    }

    @Override
    public void doWork() throws OperatorException {
        ExpressionParser parser = new ExpressionParser(this.getParameterAsBoolean(PARAMETER_USE_STANDARD_CONSTANTS));
        for (String[] nameFunctionPair : this.getParameterList(PARAMETER_FUNCTIONS)) {
            String name = nameFunctionPair[0];
            String function = nameFunctionPair[1];
            try {
                parser.addMacro(this.getProcess().getMacroHandler(), name, function);
            }
            catch (GenerationException e) {
                throw new UserError((Operator)this, 108, e.getMessage());
            }
        }
        this.dummyPorts.passDataThrough();
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeList type = new ParameterTypeList(PARAMETER_FUNCTIONS, "The list of macro names together with the expressions which define the new macros", (ParameterType)new ParameterTypeString("macro_name", "The name of the constructed macro."), (ParameterType)new ParameterTypeString("functions_expressions", "The expressions which define the new macros.", false));
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeBoolean(PARAMETER_USE_STANDARD_CONSTANTS, "Indicates if standard constants like e or pi should be available.", true));
        return types;
    }
}

