/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.CompatibilityLevel;
import com.rapidminer.operator.ports.metadata.InputMissingMetaDataError;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.PassThroughRule;
import com.rapidminer.operator.ports.metadata.Precondition;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.OperatorService;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class IOStorageOperator
extends Operator {
    private final InputPort storeInput = (InputPort)this.getInputPorts().createPort("store");
    private final OutputPort storedOutput = (OutputPort)this.getOutputPorts().createPort("stored");
    public static final String PARAMETER_NAME = "name";
    public static final String PARAMETER_IO_OBJECT = "io_object";
    public static final String PARAMETER_STORE_WHICH = "store_which";
    public static final String PARAMETER_REMOVE_FROM_PROCESS = "remove_from_process";

    public IOStorageOperator(OperatorDescription description) {
        super(description);
        this.storeInput.addPrecondition(new Precondition(){

            @Override
            public void assumeSatisfied() {
                IOStorageOperator.this.storeInput.receiveMD(new MetaData(IOStorageOperator.this.getSelectedClass()));
            }

            @Override
            public void check(MetaData metaData) {
                Class selected = IOStorageOperator.this.getSelectedClass();
                if (metaData == null) {
                    IOStorageOperator.this.storeInput.addError(new InputMissingMetaDataError(IOStorageOperator.this.storeInput, selected));
                } else if (!selected.isAssignableFrom(metaData.getObjectClass())) {
                    IOStorageOperator.this.storeInput.addError(new InputMissingMetaDataError(IOStorageOperator.this.storeInput, selected, metaData.getObjectClass()));
                }
            }

            @Override
            public String getDescription() {
                return "expect: " + IOStorageOperator.this.getSelectedClass();
            }

            @Override
            public boolean isCompatible(MetaData input, CompatibilityLevel level) {
                boolean result = input != null && IOStorageOperator.this.getSelectedClass().isAssignableFrom(input.getObjectClass());
                return result;
            }

            @Override
            public MetaData getExpectedMetaData() {
                return new MetaData(IOObject.class);
            }
        });
        this.getTransformer().addRule(new PassThroughRule(this.storeInput, this.storedOutput, false));
    }

    @Override
    public void doWork() throws OperatorException {
        Object object = this.storeInput.getData();
        if (this.getParameterAsBoolean(PARAMETER_REMOVE_FROM_PROCESS)) {
            this.getProcess().store(this.getParameterAsString(PARAMETER_NAME), (IOObject)object);
        } else {
            this.getProcess().store(this.getParameterAsString(PARAMETER_NAME), object.copy());
        }
        this.storedOutput.deliver((IOObject)object);
    }

    @Override
    public boolean shouldAutoConnect(OutputPort port) {
        if (port == this.storedOutput) {
            return !this.getParameterAsBoolean(PARAMETER_REMOVE_FROM_PROCESS);
        }
        return super.shouldAutoConnect(port);
    }

    @Override
    public LinkedList<OutputPort> preAutoWire(LinkedList<OutputPort> ports) throws UndefinedParameterError {
        Class<? extends IOObject> clazz = this.getSelectedClass();
        if (clazz != null) {
            OutputPort found = null;
            Iterator<OutputPort> i = ports.descendingIterator();
            int which = this.isParameterSet(PARAMETER_STORE_WHICH) ? this.getParameterAsInt(PARAMETER_STORE_WHICH) : 0;
            int hits = 0;
            while (i.hasNext()) {
                OutputPort port = i.next();
                if (port.getMetaData() == null || !clazz.isAssignableFrom(port.getMetaData().getObjectClass()) || ++hits != which) continue;
                found = port;
                i.remove();
                break;
            }
            if (found != null) {
                ports.addLast(found);
            }
        }
        return ports;
    }

    private Class<? extends IOObject> getSelectedClass() {
        String ioType;
        try {
            ioType = this.getParameterAsString(PARAMETER_IO_OBJECT);
        }
        catch (UndefinedParameterError e) {
            return IOObject.class;
        }
        Class<? extends IOObject> selected = OperatorService.getIOObjectClass(ioType);
        if (selected == null) {
            return IOObject.class;
        }
        return selected;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeString(PARAMETER_NAME, "The name under which the specified object is stored and can later be retrieved.", false, false));
        Set<String> ioObjects = OperatorService.getIOObjectsNames();
        String[] objectArray = new String[ioObjects.size()];
        Iterator<String> i = ioObjects.iterator();
        int index = 0;
        while (i.hasNext()) {
            objectArray[index++] = i.next();
        }
        ParameterTypeSingle type = new ParameterTypeCategory(PARAMETER_IO_OBJECT, "The class of the object which should be stored.", objectArray, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_STORE_WHICH, "Defines which input object should be stored.", 1, Integer.MAX_VALUE, 1);
        type.setDeprecated();
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_REMOVE_FROM_PROCESS, "Indicates if the stored object should be removed from the process so that following operators can only access this object after retrieving it.", true);
        type.setDeprecated();
        types.add(type);
        return types;
    }
}

