/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.OperatorService;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class IOSelectOperator
extends Operator {
    public static final String PARAMETER_IO_OBJECT = "io_object";
    public static final String PARAMETER_SELECT_WHICH = "select_which";
    public static final String PARAMETER_DELETE_OTHERS = "delete_others";
    private String[] objectArray = null;

    public IOSelectOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    public void doWork() {
        this.getLogger().info("IOSelector is deprecated and does nothing. It is only used while importing processes from earlier versions. After that, IOSelectors can be deleted.");
    }

    @Override
    protected LinkedList<OutputPort> preAutoWire(LinkedList<OutputPort> readyOutputs) throws OperatorException {
        this.getLogger().info("Simulating IOSelectOperator with old stack: " + readyOutputs);
        Class<? extends IOObject> clazz = this.getSelectedClass();
        int number = this.getParameterAsInt(PARAMETER_SELECT_WHICH);
        int hits = 0;
        Port myPort = null;
        Iterator<OutputPort> i = readyOutputs.descendingIterator();
        int count = 0;
        while (i.hasNext()) {
            OutputPort port = i.next();
            if (!port.shouldAutoConnect() || port.getMetaData() == null || !clazz.isAssignableFrom(port.getMetaData().getObjectClass())) continue;
            if (++hits == number) {
                myPort = port;
                i.remove();
                continue;
            }
            if (!this.getParameterAsBoolean(PARAMETER_DELETE_OTHERS)) continue;
            ++count;
            i.remove();
        }
        if (myPort != null) {
            readyOutputs.addLast((OutputPort)myPort);
            this.getLogger().info("Bringing output port to front: " + myPort.getSpec());
        }
        if (count > 0) {
            this.getLogger().info("Deleted " + myPort.getSpec() + " output ports.");
        }
        this.getLogger().info("New stack is: " + readyOutputs);
        return readyOutputs;
    }

    private Class<? extends IOObject> getSelectedClass() throws UndefinedParameterError {
        int ioType = this.getParameterAsInt(PARAMETER_IO_OBJECT);
        if (this.objectArray != null) {
            return OperatorService.getIOObjectClass(this.objectArray[ioType]);
        }
        return null;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        Set<String> ioObjects = OperatorService.getIOObjectsNames();
        this.objectArray = new String[ioObjects.size()];
        Iterator<String> i = ioObjects.iterator();
        int index = 0;
        while (i.hasNext()) {
            this.objectArray[index++] = i.next();
        }
        ParameterTypeSingle type = new ParameterTypeCategory(PARAMETER_IO_OBJECT, "The class of the object(s) which should be removed.", this.objectArray, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_SELECT_WHICH, "Defines which input object should be selected.", 1, Integer.MAX_VALUE, 1);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeBoolean(PARAMETER_DELETE_OTHERS, "Indicates if the other non-selected objects should be deleted.", false));
        return types;
    }
}

