/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.OperatorService;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class IORetrievalOperator
extends Operator {
    public static final String PARAMETER_NAME = "name";
    public static final String PARAMETER_IO_OBJECT = "io_object";
    public static final String PARAMETER_REMOVE_FROM_STORE = "remove_from_store";
    private String[] objectArray = null;
    private final OutputPort resultOutput = (OutputPort)this.getOutputPorts().createPort("result");

    public IORetrievalOperator(OperatorDescription description) {
        super(description);
        this.getTransformer().addRule(new MDTransformationRule(){

            @Override
            public void transformMD() {
                try {
                    Class clazz = IORetrievalOperator.this.getSelectedClass();
                    if (clazz != null) {
                        IORetrievalOperator.this.resultOutput.deliverMD(new MetaData(clazz));
                    } else {
                        IORetrievalOperator.this.resultOutput.deliverMD(new MetaData(IOObject.class));
                    }
                }
                catch (UndefinedParameterError e) {
                    IORetrievalOperator.this.getLogger().fine("Cannot transform meta data: " + e);
                }
            }
        });
    }

    private Class<? extends IOObject> getSelectedClass() throws UndefinedParameterError {
        String ioType = this.getParameterAsString(PARAMETER_IO_OBJECT);
        Class<? extends IOObject> selected = OperatorService.getIOObjectClass(ioType);
        if (selected != null) {
            return selected;
        }
        return IOObject.class;
    }

    @Override
    public void doWork() throws OperatorException {
        Class<? extends IOObject> clazz = this.getSelectedClass();
        IOObject object = null;
        if (clazz != null) {
            String name = this.getParameterAsString(PARAMETER_NAME);
            object = this.getProcess().retrieve(name, this.getParameterAsBoolean(PARAMETER_REMOVE_FROM_STORE));
            if (object == null) {
                throw new UserError((Operator)this, 941, name);
            }
            if (!clazz.isInstance(object)) {
                throw new UserError((Operator)this, 940, name, this.objectArray[this.getParameterAsInt(PARAMETER_IO_OBJECT)]);
            }
            if (this.getParameterAsBoolean(PARAMETER_REMOVE_FROM_STORE)) {
                this.resultOutput.deliver(object);
            } else {
                this.resultOutput.deliver(object.copy());
            }
        } else {
            this.resultOutput.deliver(null);
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeString(PARAMETER_NAME, "The name under which the specified object is stored and can later be retrieved.", false, false));
        Set<String> ioObjects = OperatorService.getIOObjectsNames();
        this.objectArray = new String[ioObjects.size()];
        Iterator<String> i = ioObjects.iterator();
        int index = 0;
        while (i.hasNext()) {
            this.objectArray[index++] = i.next();
        }
        ParameterTypeCategory type = new ParameterTypeCategory(PARAMETER_IO_OBJECT, "The class of the object which should be stored.", this.objectArray, 0);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeBoolean(PARAMETER_REMOVE_FROM_STORE, "Indicates if the stored object should be removed from the process store so that following operators can retrieve it again from the store.", true, false));
        return types;
    }
}

