/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.ResultObjectAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class IOObjectCollection<T extends IOObject>
extends ResultObjectAdapter {
    private static final long serialVersionUID = 1L;
    private List<T> objects;

    public IOObjectCollection() {
        this.objects = new LinkedList<T>();
    }

    public IOObjectCollection(List<T> objects) {
        this.objects = objects;
    }

    public int size() {
        return this.objects.size();
    }

    public void add(T ioobject) {
        this.objects.add(ioobject);
    }

    public IOObjectCollection(T[] objects) {
        this(Arrays.asList(objects));
    }

    public List<T> getObjects() {
        return Collections.unmodifiableList(this.objects);
    }

    @Override
    public IOObjectCollection<T> copy() {
        ArrayList<IOObject> copy = new ArrayList<IOObject>(this.objects.size());
        for (IOObject ioo : this.objects) {
            copy.add(ioo.copy());
        }
        return new IOObjectCollection(copy);
    }

    @Override
    public String toResultString() {
        StringBuilder b = new StringBuilder();
        b.append(this.objects.size() + " objects:\n");
        for (IOObject o : this.objects) {
            b.append(o.toString());
            b.append("\n");
        }
        return b.toString();
    }

    public String toString() {
        return "Collection of size " + this.objects.size();
    }

    public Class getElementClass(boolean recursive) {
        if (this.objects == null || this.objects.isEmpty()) {
            return IOObject.class;
        }
        T first = this.objects.get(0);
        if (!recursive) {
            return first.getClass();
        }
        if (first instanceof IOObjectCollection) {
            return ((IOObjectCollection)first).getElementClass(true);
        }
        return first.getClass();
    }

    public List<IOObject> getObjectsRecursive() {
        ArrayList<IOObject> allChildren = new ArrayList<IOObject>();
        this.getElementsRecursive(allChildren);
        return allChildren;
    }

    private void getElementsRecursive(List<IOObject> result) {
        for (IOObject element : this.objects) {
            if (element instanceof IOObjectCollection) {
                ((IOObjectCollection)element).getElementsRecursive(result);
                continue;
            }
            result.add(element);
        }
    }

    public IOObject getElement(int index, boolean recursive) {
        if (!recursive) {
            return (IOObject)this.objects.get(index);
        }
        return this.getObjectsRecursive().get(index);
    }
}

