/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.SimplePrecondition;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.OperatorService;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class IOMultiplyOperator
extends Operator {
    public static final String PARAMETER_NUMBER_OF_COPIES = "number_of_copies";
    public static final String PARAMETER_IO_OBJECT = "io_object";
    public static final String PARAMETER_MULTIPLY_TYPE = "multiply_type";
    public static final String PARAMETER_MULTIPLY_WHICH = "multiply_which";
    private static final String[] MULTIPLY_TYPES = new String[]{"multiply_one", "multiply_all"};
    private static final int MULTIPLY_ONE = 0;
    private static final int MULTIPLY_ALL = 1;
    private String[] objectArray = null;

    public IOMultiplyOperator(OperatorDescription description) {
        super(description);
    }

    private Class<? extends IOObject> getSelectedClass() throws UndefinedParameterError {
        String ioName = this.getParameterAsString(PARAMETER_IO_OBJECT);
        return OperatorService.getIOObjectClass(ioName);
    }

    @Override
    protected LinkedList<OutputPort> preAutoWire(LinkedList<OutputPort> readyOutputs) throws OperatorException {
        this.getInputPorts().removeAll();
        this.getOutputPorts().removeAll();
        this.getTransformer().clearRules();
        Class<? extends IOObject> desiredClass = this.getSelectedClass();
        int hits = 0;
        if (desiredClass != null) {
            switch (this.getParameterAsInt(PARAMETER_MULTIPLY_TYPE)) {
                case 0: {
                    MetaData md;
                    OutputPort port;
                    OutputPort found = null;
                    int number = this.getParameterAsInt(PARAMETER_MULTIPLY_WHICH);
                    Iterator<OutputPort> i = readyOutputs.descendingIterator();
                    while (i.hasNext()) {
                        port = i.next();
                        md = port.getMetaData();
                        if (md == null || !desiredClass.isAssignableFrom(md.getObjectClass()) || ++hits != number) continue;
                        this.getInputPorts().createPort("input_1", desiredClass);
                        this.getLogger().info("IOMultiplier created temporary input: input_1");
                        found = port;
                        break;
                    }
                    if (found == null) break;
                    readyOutputs.remove(found);
                    readyOutputs.addLast(found);
                    break;
                }
                case 1: {
                    MetaData md;
                    OutputPort port;
                    Iterator<OutputPort> i = readyOutputs.descendingIterator();
                    while (i.hasNext()) {
                        port = i.next();
                        md = port.getMetaData();
                        if (md == null || !desiredClass.isAssignableFrom(md.getObjectClass())) continue;
                        InputPort inPort = (InputPort)this.getInputPorts().createPort("input_" + ++hits, false);
                        this.getLogger().info("IOMultiplier created temporary input: input_" + hits);
                        inPort.addPrecondition(new SimplePrecondition(inPort, new MetaData(desiredClass)));
                        this.getInputPorts().addPort(inPort);
                    }
                    break;
                }
            }
        }
        int copies = this.getParameterAsInt(PARAMETER_MULTIPLY_WHICH) + 1;
        for (int i = 0; i < this.getInputPorts().getNumberOfPorts(); ++i) {
            InputPort in = (InputPort)this.getInputPorts().getPortByIndex(i);
            for (int j = 0; j < copies; ++j) {
                OutputPort out = (OutputPort)this.getOutputPorts().createPort("output_" + (i + 1) + "_" + (j + 1));
                this.getLogger().info("IOMultiplier created temporary output: output_" + (i + 1) + "_" + (j + 1));
                this.getTransformer().addPassThroughRule(in, out);
            }
        }
        return readyOutputs;
    }

    @Override
    public void doWork() throws OperatorException {
        this.getLogger().warning("This operator is deprecated and should have been replaced during import by IOMultiplier2");
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        Set<String> ioObjects = OperatorService.getIOObjectsNames();
        this.objectArray = new String[ioObjects.size()];
        Iterator<String> i = ioObjects.iterator();
        int index = 0;
        while (i.hasNext()) {
            this.objectArray[index++] = i.next();
        }
        ParameterTypeSingle type = new ParameterTypeInt(PARAMETER_NUMBER_OF_COPIES, "The number of copies which should be created.", 1, Integer.MAX_VALUE, 1);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeCategory(PARAMETER_IO_OBJECT, "The class of the object(s) which should be multiplied.", this.objectArray, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeCategory(PARAMETER_MULTIPLY_TYPE, "Defines the type of multiplying.", MULTIPLY_TYPES, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_MULTIPLY_WHICH, "Defines which input object should be multiplied (only used for deletion type 'multiply_one').", 1, Integer.MAX_VALUE, 1);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

