/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.OutputPortExtender;

public class IOMultiplier
extends Operator {
    private final InputPort inputPort = (InputPort)this.getInputPorts().createPort("input");
    private final OutputPortExtender outputExtender = new OutputPortExtender("output", this.getOutputPorts());

    public IOMultiplier(OperatorDescription description) {
        super(description);
        this.outputExtender.start();
        this.getTransformer().addRule(this.outputExtender.makePassThroughRule(this.inputPort));
    }

    @Override
    public void doWork() {
        IOObject input = this.inputPort.getAnyDataOrNull();
        if (input != null) {
            for (OutputPort outputPort : this.outputExtender.getManagedPorts()) {
                outputPort.deliver(input.copy());
            }
        }
    }

    public InputPort getInputPort() {
        return this.inputPort;
    }
}

