/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.OperatorService;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class IOConsumeOperator
extends Operator {
    public static final String PARAMETER_IO_OBJECT = "io_object";
    public static final String PARAMETER_DELETION_TYPE = "deletion_type";
    public static final String PARAMETER_DELETE_WHICH = "delete_which";
    public static final String PARAMETER_EXCEPT = "except";
    private static final String[] DELETION_TYPES = new String[]{"delete_one", "delete_all", "delete_all_but", "delete_all_but_number"};
    public static final int DELETE_ONE = 0;
    public static final int DELETE_ALL = 1;
    public static final int DELETE_ALL_BUT = 2;
    public static final int DELETE_ALL_BUT_NUMBER = 3;
    private String[] objectArray = null;

    public IOConsumeOperator(OperatorDescription description) {
        super(description);
    }

    private Class<? extends IOObject> getSelectedClass() throws UndefinedParameterError {
        int ioType = this.getParameterAsInt(PARAMETER_IO_OBJECT);
        if (this.objectArray != null) {
            return OperatorService.getIOObjectClass(this.objectArray[ioType]);
        }
        return null;
    }

    @Override
    public void doWork() {
        this.getLogger().info("IOConsumer is deprecated and does nothing. It is only used while importing processes from earlier versions. After that, IOConsumers can be deleted.");
    }

    @Override
    protected LinkedList<OutputPort> preAutoWire(LinkedList<OutputPort> readyOutputs) throws OperatorException {
        this.getLogger().info("Simulating IOConsumeOperator with old stack: " + readyOutputs);
        Class<? extends IOObject> clazz = this.getSelectedClass();
        Iterator<OutputPort> i = readyOutputs.descendingIterator();
        if (clazz != null) {
            block0 : switch (this.getParameterAsInt(PARAMETER_DELETION_TYPE)) {
                case 0: {
                    int number = this.getParameterAsInt(PARAMETER_DELETE_WHICH);
                    int hits = 0;
                    while (i.hasNext()) {
                        OutputPort port = i.next();
                        if (!port.shouldAutoConnect() || port.getMetaData() == null || !clazz.isAssignableFrom(port.getMetaData().getObjectClass()) || ++hits != number) continue;
                        i.remove();
                        this.getLogger().info("Deleted " + number + ". " + clazz.getName() + ".");
                        break block0;
                    }
                    break;
                }
                case 1: {
                    int counter = 0;
                    while (i.hasNext()) {
                        OutputPort port = i.next();
                        if (!port.shouldAutoConnect() || port.getMetaData() == null || !clazz.isAssignableFrom(port.getMetaData().getObjectClass())) continue;
                        ++counter;
                        i.remove();
                    }
                    this.getLogger().info("Deleted " + counter + " " + clazz.getName() + ".");
                    break;
                }
                case 2: {
                    int counter = 0;
                    while (i.hasNext()) {
                        OutputPort port = i.next();
                        if (!port.shouldAutoConnect() || port.getMetaData() == null || clazz.isAssignableFrom(port.getMetaData().getObjectClass())) continue;
                        ++counter;
                        i.remove();
                    }
                    this.getLogger().info("Deleted " + counter + " input objects.");
                    break;
                }
                case 3: {
                    int counter = 0;
                    int hits = 0;
                    int number = this.getParameterAsInt(PARAMETER_EXCEPT);
                    while (i.hasNext()) {
                        OutputPort port = i.next();
                        if (!port.shouldAutoConnect() || port.getMetaData() == null || !clazz.isAssignableFrom(port.getMetaData().getObjectClass()) || ++hits == number) continue;
                        i.remove();
                        ++counter;
                        this.getLogger().info("Deleted " + number + ". " + clazz.getName() + ".");
                        break;
                    }
                    this.getLogger().info("Deleted " + counter + " " + clazz.getName() + ".");
                }
            }
        }
        this.getLogger().info("New stack: " + readyOutputs);
        return readyOutputs;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        Set<String> ioObjects = OperatorService.getIOObjectsNames();
        this.objectArray = new String[ioObjects.size()];
        Iterator<String> i = ioObjects.iterator();
        int index = 0;
        while (i.hasNext()) {
            this.objectArray[index++] = i.next();
        }
        ParameterTypeSingle type = new ParameterTypeCategory(PARAMETER_IO_OBJECT, "The class of the object(s) which should be removed.", this.objectArray, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeCategory(PARAMETER_DELETION_TYPE, "Defines the type of deletion.", DELETION_TYPES, 1);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_DELETE_WHICH, "Defines which input object should be deleted (only used for deletion type 'delete_one').", 1, Integer.MAX_VALUE, 1);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_EXCEPT, "Defines which input object should not be deleted (only used for deletion type 'delete_one_but_number').", 1, Integer.MAX_VALUE, 1);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

