/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.DummyPortPairExtender;
import com.rapidminer.operator.ports.PortPairExtender;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.ParameterTypeText;
import com.rapidminer.parameter.TextType;
import com.rapidminer.tools.io.Encoding;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.List;

public class FileEchoOperator
extends Operator {
    public static final String PARAMETER_FILE = "file";
    public static final String PARAMETER_TEXT = "text";
    private PortPairExtender dummyPorts = new DummyPortPairExtender("through", this.getInputPorts(), this.getOutputPorts());

    public FileEchoOperator(OperatorDescription description) {
        super(description);
        this.dummyPorts.start();
        this.getTransformer().addRule(this.dummyPorts.makePassThroughRule());
    }

    @Override
    public void doWork() throws OperatorException {
        File file = this.getParameterAsFile(PARAMETER_FILE, true);
        String text = this.getParameterAsString(PARAMETER_TEXT);
        PrintWriter out = null;
        try {
            out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), Encoding.getEncoding(this)));
            out.println(text);
        }
        catch (IOException e) {
            throw new UserError((Operator)this, 303, file.getName(), e);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        this.dummyPorts.passDataThrough();
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeString type = new ParameterTypeFile(PARAMETER_FILE, "The file into which this operator should write the specified text.", "out", false);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeText(PARAMETER_TEXT, "The text which should be written into the file.", TextType.PLAIN, false);
        type.setExpert(false);
        types.add(type);
        types.addAll(Encoding.getParameterTypes(this));
        return types;
    }
}

