/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.Process;
import com.rapidminer.operator.EnabledOperatorView;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessRootOperator;
import com.rapidminer.operator.execution.UnitExecutionFactory;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.InputPorts;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.OutputPorts;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.PortException;
import com.rapidminer.operator.ports.PortOwner;
import com.rapidminer.operator.ports.impl.InputPortsImpl;
import com.rapidminer.operator.ports.impl.OutputPortsImpl;
import com.rapidminer.operator.ports.metadata.CompatibilityLevel;
import com.rapidminer.operator.ports.metadata.OperatorLoopError;
import com.rapidminer.tools.AbstractObservable;
import com.rapidminer.tools.DelegatingObserver;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Observer;
import com.rapidminer.tools.Tools;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.Vector;
import java.util.logging.Level;

public class ExecutionUnit
extends AbstractObservable<ExecutionUnit> {
    private final PortOwner portOwner = new PortOwner(){

        @Override
        public OperatorChain getPortHandler() {
            return ExecutionUnit.this.getEnclosingOperator();
        }

        @Override
        public String getName() {
            return ExecutionUnit.this.getName();
        }

        @Override
        public Operator getOperator() {
            return ExecutionUnit.this.getEnclosingOperator();
        }

        @Override
        public ExecutionUnit getConnectionContext() {
            return ExecutionUnit.this;
        }
    };
    private String name;
    private final OperatorChain enclosingOperator;
    private final InputPorts innerInputPorts = new InputPortsImpl(this.portOwner);
    private final OutputPorts innerOutputPorts = new OutputPortsImpl(this.portOwner);
    private Vector<Operator> operators = new Vector();
    private Vector<Operator> executionOrder;
    private final Observer<Port> delegatingPortObserver = new DelegatingObserver<Port, ExecutionUnit>(this, this);
    private final Observer<Operator> delegatingOperatorObserver = new DelegatingObserver<Operator, ExecutionUnit>(this, this);
    private boolean expanded = true;

    public ExecutionUnit(OperatorChain enclosingOperator, String name) {
        this.name = name;
        this.enclosingOperator = enclosingOperator;
        this.innerInputPorts.addObserver(this.delegatingPortObserver, false);
        this.innerOutputPorts.addObserver(this.delegatingPortObserver, false);
        int index = 0;
        do {
            char c;
            if (Character.isUpperCase(c = name.charAt(index)) || Character.isDigit(c)) continue;
            LogService.getRoot().warning("Process name does not follow naming conventions: " + name + " (in " + enclosingOperator.getOperatorDescription().getName() + ")");
        } while ((index = name.indexOf(32, index) + 1) != 0);
    }

    public InputPorts getInnerSinks() {
        return this.innerInputPorts;
    }

    public OutputPorts getInnerSources() {
        return this.innerOutputPorts;
    }

    public int addOperator(Operator operator) {
        return this.addOperator(operator, true);
    }

    public int addOperator(Operator operator, boolean registerWithProcess) {
        if (operator == null) {
            throw new NullPointerException("operator cannot be null!");
        }
        if (operator instanceof ProcessRootOperator) {
            throw new IllegalArgumentException("'Process' operator cannot be added. It must always be the top-level operator!");
        }
        this.operators.add(operator);
        this.registerOperator(operator, registerWithProcess);
        return this.operators.size() - 1;
    }

    public void addOperator(Operator operator, int index) {
        if (operator == null) {
            throw new NullPointerException("operator cannot be null!");
        }
        if (operator instanceof ProcessRootOperator) {
            throw new IllegalArgumentException("'Process' operator cannot be added. It must always be the top-level operator!");
        }
        this.operators.add(index, operator);
        this.registerOperator(operator, true);
    }

    public int getIndexOfOperator(Operator operator) {
        return this.operators.indexOf(operator);
    }

    private void registerOperator(Operator operator, boolean registerWithProcess) {
        operator.setEnclosingProcess(this);
        Process process = this.getEnclosingOperator().getProcess();
        if (process != null && registerWithProcess) {
            operator.registerOperator(process);
        }
        this.fireUpdate(this);
        operator.addObserver(this.delegatingOperatorObserver, false);
        operator.clear(31);
        if (process != null) {
            process.fireOperatorAdded(operator);
        }
    }

    private void unregister(Operator operator) {
        operator.removeObserver(this.delegatingOperatorObserver);
    }

    protected void removeOperator(Operator operator) {
        if (!this.operators.contains(operator)) {
            throw new NoSuchElementException("Operator " + operator.getName() + " not contained in " + this.getName() + "!");
        }
        int oldIndex = this.operators.indexOf(operator);
        int oldIndexAmongEnabled = this.getEnabledOperators().indexOf(operator);
        this.operators.remove(operator);
        this.unregister(operator);
        Process process = this.getEnclosingOperator().getProcess();
        if (process != null) {
            process.fireOperatorRemoved(operator, oldIndex, oldIndexAmongEnabled);
        }
        operator.setEnclosingProcess(null);
        this.fireUpdate(this);
    }

    public void clear(int clearFlags) {
        for (Operator operator : this.operators) {
            operator.clear(clearFlags);
        }
        this.getInnerSinks().clear(clearFlags);
        this.getInnerSources().clear(clearFlags);
    }

    public Vector<Operator> topologicalSort() {
        final HashMap<Operator, Integer> originalIndices = new HashMap<Operator, Integer>();
        for (int i = 0; i < this.operators.size(); ++i) {
            originalIndices.put(this.operators.get(i), i);
        }
        EdgeCounter counter = new EdgeCounter(this.operators);
        for (Operator child : this.getOperators()) {
            for (OutputPort out : child.getOutputPorts().getAllPorts()) {
                InputPort dest = out.getDestination();
                if (dest == null) continue;
                counter.incNumEdges(dest.getPorts().getOwner().getOperator());
            }
        }
        Vector<Operator> sorted = new Vector<Operator>();
        PriorityQueue<Operator> independentOperators = new PriorityQueue<Operator>(Math.max(1, this.operators.size()), new Comparator<Operator>(){

            @Override
            public int compare(Operator o1, Operator o2) {
                return (Integer)originalIndices.get(o1) - (Integer)originalIndices.get(o2);
            }
        });
        independentOperators.addAll(counter.getIndependentOperators());
        while (!independentOperators.isEmpty()) {
            Operator first = independentOperators.poll();
            sorted.add(first);
            for (OutputPort out : first.getOutputPorts().getAllPorts()) {
                Operator destOp;
                InputPort dest = out.getDestination();
                if (dest == null || counter.decNumEdges(destOp = dest.getPorts().getOwner().getOperator()) != 0) continue;
                independentOperators.add(destOp);
            }
        }
        return sorted;
    }

    protected void updateExecutionOrder() {
        this.executionOrder = this.topologicalSort();
        if (!this.executionOrder.equals(this.operators)) {
            if (this.operators.size() != this.executionOrder.size()) {
                return;
            }
            this.operators = this.executionOrder;
            this.getEnclosingOperator().getProcess().fireExecutionOrderChanged(this);
        }
        for (Operator operator : this.operators) {
            operator.updateExecutionOrder();
        }
    }

    public void transformMetaData() {
        Vector<Operator> sorted = this.topologicalSort();
        for (Operator op : sorted) {
            op.transformMetaData();
        }
        if (sorted.size() != this.operators.size()) {
            LinkedList<Operator> remainder = new LinkedList<Operator>(this.operators);
            remainder.removeAll(sorted);
            for (Operator nodeInCircle : remainder) {
                for (OutputPort outputPort : nodeInCircle.getOutputPorts().getAllPorts()) {
                    InputPort destination = outputPort.getDestination();
                    if (destination == null || !remainder.contains(destination.getPorts().getOwner().getOperator())) continue;
                    if (destination.getSource() != null) {
                        destination.addError(new OperatorLoopError(destination));
                    }
                    outputPort.addError(new OperatorLoopError(outputPort));
                }
            }
        }
        this.getInnerSinks().checkPreconditions();
    }

    public List<Operator> getOperators() {
        return Collections.unmodifiableList(this.operators);
    }

    public Enumeration<Operator> getOperatorEnumeration() {
        return this.operators.elements();
    }

    public List<Operator> getEnabledOperators() {
        return new EnabledOperatorView(this.operators);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public OperatorChain getEnclosingOperator() {
        return this.enclosingOperator;
    }

    private void unwire(boolean recursive) {
        this.getInnerSources().disconnectAll();
        for (Operator op : this.getOperators()) {
            this.unwire(op, recursive);
        }
    }

    private void unwire(Operator op, boolean recursive) throws PortException {
        op.getOutputPorts().disconnectAll();
        if (recursive && op instanceof OperatorChain) {
            for (ExecutionUnit subprocess : ((OperatorChain)op).getSubprocesses()) {
                subprocess.unwire(recursive);
            }
        }
    }

    private void autoWire(CompatibilityLevel level, InputPorts inputPorts, LinkedList<OutputPort> readyOutputs) throws PortException {
        boolean success = false;
        block0: do {
            HashSet<InputPort> complete = new HashSet<InputPort>();
            for (InputPort in : inputPorts.getAllPorts()) {
                success = false;
                if (in.isConnected() || complete.contains(in) || !in.getPorts().getOwner().getOperator().shouldAutoConnect(in)) continue;
                Iterator<OutputPort> outIterator = in.simulatesStack() ? readyOutputs.descendingIterator() : readyOutputs.descendingIterator();
                while (outIterator.hasNext()) {
                    OutputPort outCandidate = outIterator.next();
                    Operator owner = outCandidate.getPorts().getOwner().getOperator();
                    if (!owner.shouldAutoConnect(outCandidate) || outCandidate.getMetaData() == null || !in.isInputCompatible(outCandidate.getMetaData(), level)) continue;
                    readyOutputs.remove(outCandidate);
                    outCandidate.connectTo(in);
                    success = true;
                    break;
                }
                complete.add(in);
                if (!success) continue;
                continue block0;
            }
        } while (success);
    }

    private void transformMDNeighbourhood() {
        this.getEnclosingOperator().transformMetaData();
    }

    public void autoWire(CompatibilityLevel level, boolean keepConnections, boolean recursive) throws PortException {
        if (!keepConnections) {
            this.unwire(recursive);
        }
        LinkedList<OutputPort> readyOutputs = new LinkedList<OutputPort>();
        this.addReadyOutputs(readyOutputs, this.getInnerSources());
        LinkedList<Operator> enabled = new LinkedList<Operator>();
        for (Operator op : this.getOperators()) {
            if (!op.isEnabled()) continue;
            enabled.add(op);
        }
        this.autoWire(level, enabled, readyOutputs, recursive, true);
    }

    private void autoWire(CompatibilityLevel level, List<Operator> operators, LinkedList<OutputPort> readyOutputs, boolean recursive, boolean wireNew) throws PortException {
        this.transformMDNeighbourhood();
        for (Operator op : operators) {
            try {
                readyOutputs = op.preAutoWire(readyOutputs);
            }
            catch (OperatorException e) {
                this.getEnclosingOperator().getLogger().log(Level.WARNING, "During auto-wiring: " + e, e);
            }
            this.autoWire(level, op.getInputPorts(), readyOutputs);
            this.transformMDNeighbourhood();
            if (recursive && op instanceof OperatorChain) {
                for (ExecutionUnit subprocess : ((OperatorChain)op).getSubprocesses()) {
                    subprocess.autoWire(level, true, recursive);
                }
            }
            if (!wireNew) continue;
            this.addReadyOutputs(readyOutputs, op.getOutputPorts());
        }
        this.autoWire(level, this.getInnerSinks(), readyOutputs);
        this.transformMDNeighbourhood();
    }

    public void autoWireSingle(Operator operator, CompatibilityLevel level, boolean inputs, boolean outputs) {
        LinkedList<OutputPort> readyOutputs;
        if (inputs) {
            this.transformMDNeighbourhood();
            readyOutputs = new LinkedList<OutputPort>();
            this.addReadyOutputs(readyOutputs, this.getInnerSources());
            boolean found = false;
            for (Operator other : this.operators) {
                if (other == operator) {
                    found = true;
                    break;
                }
                this.addReadyOutputs(readyOutputs, other.getOutputPorts());
            }
            if (!found) {
                throw new IllegalArgumentException("Operator " + operator.getName() + " does not belong to this subprocess " + this.getName() + ".");
            }
            this.getEnclosingOperator().getLogger().fine("Wiring: " + operator + "." + operator.getInputPorts().getAllPorts() + " to " + readyOutputs);
            this.autoWire(level, operator.getInputPorts(), readyOutputs);
        }
        if (outputs) {
            readyOutputs = new LinkedList();
            this.addReadyOutputs(readyOutputs, operator.getOutputPorts());
            LinkedList<Operator> successors = new LinkedList<Operator>();
            boolean foundMe = false;
            for (Operator other : this.getOperators()) {
                if (foundMe) {
                    successors.add(other);
                    continue;
                }
                if (other != operator) continue;
                foundMe = true;
            }
            this.autoWire(level, successors, readyOutputs, false, false);
        }
    }

    private void addReadyOutputs(LinkedList<OutputPort> readyOutputs, OutputPorts ports) {
        Iterator i = new LinkedList(ports.getAllPorts()).descendingIterator();
        while (i.hasNext()) {
            OutputPort port = (OutputPort)i.next();
            if (port.isConnected() || !port.shouldAutoConnect()) continue;
            readyOutputs.addLast(port);
        }
    }

    public Collection<OutputPort> getAllOutputPorts() {
        LinkedList<OutputPort> outputPorts = new LinkedList<OutputPort>();
        outputPorts.addAll(this.getInnerSources().getAllPorts());
        for (Operator operator : this.operators) {
            outputPorts.addAll(operator.getOutputPorts().getAllPorts());
        }
        return outputPorts;
    }

    public Operator getOperatorByName(String toOp) {
        for (Operator op : this.operators) {
            if (!op.getName().equals(toOp)) continue;
            return op;
        }
        return null;
    }

    public int getNumberOfOperators() {
        return this.operators.size();
    }

    public void cloneExecutionUnitFrom(ExecutionUnit original, boolean forParallelExecution) {
        HashMap<String, Operator> clonedOperatorsByName = new HashMap<String, Operator>();
        for (Operator originalChild : original.operators) {
            Operator clonedOperator = originalChild.cloneOperator(originalChild.getName(), forParallelExecution);
            this.addOperator(clonedOperator, !forParallelExecution);
            clonedOperatorsByName.put(originalChild.getName(), clonedOperator);
        }
        this.cloneConnections(original.getInnerSources(), original, clonedOperatorsByName);
        for (Operator op : original.operators) {
            this.cloneConnections(op.getOutputPorts(), original, clonedOperatorsByName);
        }
        original.getInnerSources().unlockPortExtenders();
        original.getInnerSinks().unlockPortExtenders();
        for (Operator op : this.operators) {
            op.getInputPorts().unlockPortExtenders();
            op.getOutputPorts().unlockPortExtenders();
        }
        this.expanded = original.expanded;
    }

    private void cloneConnections(OutputPorts originalPorts, ExecutionUnit originalExecutionUnit, Map<String, Operator> clonedOperatorsByName) {
        for (OutputPort originalSource : originalPorts.getAllPorts()) {
            InputPort myDestination;
            InputPort originalDestination;
            OutputPort mySource;
            if (!originalSource.isConnected()) continue;
            if (originalPorts.getOwner().getOperator() == originalExecutionUnit.getEnclosingOperator()) {
                mySource = (OutputPort)this.getInnerSources().getPortByName(originalSource.getName());
                if (mySource == null) {
                    throw new RuntimeException("Error during clone: Corresponding source for " + originalSource + " not found (no such inner source).");
                }
            } else {
                Operator myOperator = clonedOperatorsByName.get(originalSource.getPorts().getOwner().getOperator().getName());
                if (myOperator == null) {
                    throw new RuntimeException("Error during clone: Corresponding source for " + originalSource + " not found (no such operator).");
                }
                mySource = (OutputPort)myOperator.getOutputPorts().getPortByName(originalSource.getName());
                if (mySource == null) {
                    throw new RuntimeException("Error during clone: Corresponding source for " + originalSource + " not found (no such output port).");
                }
            }
            if ((originalDestination = originalSource.getDestination()).getPorts().getOwner().getOperator() == originalExecutionUnit.getEnclosingOperator()) {
                myDestination = (InputPort)this.getInnerSinks().getPortByName(originalDestination.getName());
                if (myDestination == null) {
                    throw new RuntimeException("Error during clone: Corresponding destination for " + originalDestination + " not found (no such inner sink).");
                }
            } else {
                Operator myOperator = clonedOperatorsByName.get(originalDestination.getPorts().getOwner().getOperator().getName());
                if (myOperator == null) {
                    throw new RuntimeException("Error during clone: Corresponding destination for " + originalDestination + " not found (no such operator).");
                }
                myDestination = (InputPort)myOperator.getInputPorts().getPortByName(originalDestination.getName());
                if (myDestination == null) {
                    throw new RuntimeException("Error during clone: Corresponding destination for " + originalDestination + " not found (no such input port).");
                }
            }
            mySource.connectTo(myDestination);
        }
    }

    public Collection<Operator> getChildOperators() {
        LinkedList<Operator> children = new LinkedList<Operator>();
        for (Operator operator : this.operators) {
            children.add(operator);
        }
        return children;
    }

    public List<Operator> getAllInnerOperators() {
        LinkedList<Operator> children = new LinkedList<Operator>();
        for (Operator operator : this.operators) {
            children.add(operator);
            if (!(operator instanceof OperatorChain)) continue;
            children.addAll(((OperatorChain)operator).getAllInnerOperators());
        }
        return children;
    }

    protected String createProcessTree(int indent, String selfPrefix, String childPrefix, Operator markOperator, String mark) {
        String tree = Tools.indent(indent) + " subprocess '" + this.getName() + "'";
        Iterator<Operator> i = this.operators.iterator();
        while (i.hasNext()) {
            tree = tree + Tools.getLineSeparator() + i.next().createProcessTree(indent, childPrefix + "+- ", childPrefix + (i.hasNext() ? "|  " : "   "), markOperator, mark);
        }
        return tree;
    }

    public void execute() throws OperatorException {
        UnitExecutionFactory.getInstance().getExecutor(this).execute(this);
    }

    public void freeMemory() {
        this.getInnerSources().freeMemory();
        this.getInnerSinks().freeMemory();
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void processStarts() throws OperatorException {
        for (Operator operator : this.operators) {
            operator.processStarts();
        }
        this.executionOrder = this.topologicalSort();
    }

    public void processFinished() throws OperatorException {
        for (Operator operator : this.operators) {
            operator.processFinished();
        }
    }

    public int stealOperatorsFrom(ExecutionUnit otherUnit) {
        int failedReconnects = 0;
        HashMap<String, InputPort> sourceMap = new HashMap<String, InputPort>();
        HashMap<String, OutputPort> sinkMap = new HashMap<String, OutputPort>();
        for (OutputPort source : otherUnit.getInnerSources().getAllPorts()) {
            if (!source.isConnected()) continue;
            sourceMap.put(source.getName(), source.getDestination());
        }
        otherUnit.getInnerSources().disconnectAll();
        for (InputPort sink : otherUnit.getInnerSinks().getAllPorts()) {
            if (!sink.isConnected()) continue;
            sinkMap.put(sink.getName(), sink.getSource());
        }
        otherUnit.getInnerSinks().disconnectAll();
        Iterator<Operator> i = otherUnit.operators.iterator();
        while (i.hasNext()) {
            Operator operator = i.next();
            i.remove();
            otherUnit.unregister(operator);
            Process otherProcess = operator.getProcess();
            if (otherProcess != null) {
                operator.unregisterOperator(otherProcess);
            }
            this.operators.add(operator);
            operator.setEnclosingProcess(null);
            this.registerOperator(operator, true);
        }
        for (Map.Entry entry : sourceMap.entrySet()) {
            OutputPort mySource = (OutputPort)this.getInnerSources().getPortByName((String)entry.getKey());
            if (mySource != null) {
                mySource.connectTo((InputPort)entry.getValue());
                continue;
            }
            ++failedReconnects;
        }
        this.getInnerSources().unlockPortExtenders();
        for (Map.Entry entry : sinkMap.entrySet()) {
            InputPort mySink = (InputPort)this.getInnerSinks().getPortByName((String)entry.getKey());
            if (mySink != null) {
                ((OutputPort)entry.getValue()).connectTo(mySink);
                continue;
            }
            ++failedReconnects;
        }
        this.getInnerSinks().unlockPortExtenders();
        this.fireUpdate(this);
        return failedReconnects;
    }

    public void moveToIndex(Operator op, int newIndex) {
        int oldIndex = this.operators.indexOf(op);
        Process process = this.getEnclosingOperator().getProcess();
        if (oldIndex != -1) {
            this.operators.remove(op);
            if (process != null) {
                int oldIndexAmongEnabled = this.getEnabledOperators().indexOf(op);
                process.fireOperatorRemoved(op, oldIndex, oldIndexAmongEnabled);
            }
            if (oldIndex < newIndex) {
                --newIndex;
            }
            this.operators.add(newIndex, op);
            if (process != null) {
                process.fireOperatorAdded(op);
            }
            this.fireUpdate();
            this.updateExecutionOrder();
        }
    }

    public void bringToFront(Collection<Operator> movedOperators, Operator insertAfter) {
        this.operators.removeAll(movedOperators);
        int index = this.operators.indexOf(insertAfter) + 1;
        for (Operator op : movedOperators) {
            this.operators.add(index++, op);
        }
        this.updateExecutionOrder();
        this.fireUpdate();
    }

    private static class EdgeCounter {
        private final Map<Operator, Integer> numIncomingEdges = new LinkedHashMap<Operator, Integer>();

        private EdgeCounter(Collection<Operator> operators) {
            for (Operator op : operators) {
                this.numIncomingEdges.put(op, 0);
            }
        }

        private void incNumEdges(Operator op) {
            Integer num = this.numIncomingEdges.get(op);
            if (num == null) {
                return;
            }
            num = num + 1;
            this.numIncomingEdges.put(op, num);
        }

        private int decNumEdges(Operator op) {
            Integer num = this.numIncomingEdges.get(op);
            if (num == null) {
                return -1;
            }
            num = num - 1;
            assert (num >= 0);
            this.numIncomingEdges.put(op, num);
            return num;
        }

        private LinkedList<Operator> getIndependentOperators() {
            LinkedList<Operator> independentOperators = new LinkedList<Operator>();
            for (Map.Entry<Operator, Integer> entry : this.numIncomingEdges.entrySet()) {
                if (entry.getValue() != null && entry.getValue() != 0) continue;
                independentOperators.add(entry.getKey());
            }
            return independentOperators;
        }
    }
}

