/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapid_i.deployment.update.client.UpdateDialog;
import com.rapid_i.deployment.update.client.UpdateManager;
import com.rapidminer.deployment.client.wsimport.PackageDescriptor;
import com.rapidminer.deployment.client.wsimport.UpdateService;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.SimpleProcessSetupError;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPortExtender;
import com.rapidminer.operator.ports.OutputPortExtender;
import com.rapidminer.operator.ports.quickfix.AbstractQuickFix;
import com.rapidminer.operator.ports.quickfix.QuickFix;
import com.rapidminer.tools.LogService;
import java.util.Collections;
import java.util.logging.Level;

public class DummyOperator
extends Operator {
    private InputPortExtender inExtender = new InputPortExtender("in", this.getInputPorts());
    private OutputPortExtender outExtender = new OutputPortExtender("out", this.getOutputPorts());
    private String replaces;
    private QuickFix installFix = null;

    public DummyOperator(OperatorDescription description) {
        super(description);
        this.inExtender.start();
        this.outExtender.start();
    }

    @Override
    protected void performAdditionalChecks() {
        super.performAdditionalChecks();
        if (this.installFix != null) {
            this.addError(new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, this.getPortOwner(), Collections.singletonList(this.installFix), "dummy_operator", this.getReplaces()));
        } else {
            this.addError(new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, this.getPortOwner(), "dummy_operator", this.getReplaces()));
        }
    }

    private String getRequiredPluginPrefix() {
        if (this.getReplaces() == null) {
            return null;
        }
        if (this.getReplaces().startsWith("W-")) {
            return "weka";
        }
        if (this.getReplaces().indexOf(58) != -1) {
            return this.getReplaces().substring(0, this.getReplaces().indexOf(58));
        }
        return null;
    }

    @Override
    public void doWork() throws UserError {
        throw new UserError((Operator)this, 151, this.getName(), this.getReplaces());
    }

    public void setReplaces(String replaces) {
        this.replaces = replaces;
        this.installFix = replaces != null ? new AbstractQuickFix(10, true, "install_extension", new Object[]{this.getExtensionName()}){

            @Override
            public void apply() {
                UpdateDialog.showUpdateDialog(DummyOperator.this.getExtensionId());
            }
        } : null;
    }

    public String getReplaces() {
        return this.replaces;
    }

    private String getExtensionId() {
        try {
            UpdateService service = UpdateManager.getService();
            String extensionId = service.getRapidMinerExtensionForOperatorPrefix(this.getRequiredPluginPrefix());
            if (extensionId == null) {
                return this.getRequiredPluginPrefix();
            }
            return extensionId;
        }
        catch (Exception e) {
            LogService.getRoot().log(Level.WARNING, "Cannot connect to update service: " + e, e);
            return this.getRequiredPluginPrefix();
        }
    }

    private String getExtensionName() {
        try {
            UpdateService service = UpdateManager.getService();
            String extensionId = service.getRapidMinerExtensionForOperatorPrefix(this.getRequiredPluginPrefix());
            if (extensionId == null) {
                return this.getRequiredPluginPrefix();
            }
            String latest = service.getLatestVersion(extensionId, "ANY");
            PackageDescriptor desc = service.getPackageInfo(extensionId, latest, "ANY");
            return desc.getName();
        }
        catch (Exception e) {
            LogService.getRoot().log(Level.WARNING, "Cannot connect to update service: " + e, e);
            return this.getRequiredPluginPrefix();
        }
    }
}

