/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.operator.IODescription;
import com.rapidminer.operator.IllegalInputException;
import com.rapidminer.operator.Operator;
import java.util.Iterator;
import java.util.LinkedList;

public class DefaultIODescription
implements IODescription {
    public static final int PASS_UNUSED_INPUT_TO_OUTPUT = 1;
    public static final int DELETE_UNUSED_INPUT = 2;
    private Class<?>[] inputClasses;
    private Class<?>[] outputClasses;
    private int outputBehaviour;

    public DefaultIODescription(Class[] input, Class[] output, int outputBehaviour) {
        this.inputClasses = input;
        this.outputClasses = output;
        if (this.inputClasses == null) {
            this.inputClasses = new Class[0];
        }
        if (this.outputClasses == null) {
            this.outputClasses = new Class[0];
        }
        this.outputBehaviour = outputBehaviour;
    }

    public DefaultIODescription(Class[] input, Class[] output) {
        this(input, output, 1);
    }

    @Override
    public Class<?>[] getInputClasses() {
        return this.inputClasses;
    }

    @Override
    public Class<?>[] getOutputClasses(Class<?>[] input, Operator operator) throws IllegalInputException {
        switch (this.outputBehaviour) {
            case 1: {
                int i;
                LinkedList outputList = new LinkedList();
                for (i = 0; i < input.length; ++i) {
                    outputList.add(input[i]);
                }
                for (i = 0; i < this.inputClasses.length; ++i) {
                    boolean found = false;
                    Iterator j = outputList.iterator();
                    while (j.hasNext()) {
                        if (!this.inputClasses[i].isAssignableFrom((Class)j.next())) continue;
                        j.remove();
                        found = true;
                        break;
                    }
                    if (found) continue;
                    throw new IllegalInputException(operator, this.inputClasses[i]);
                }
                for (i = 0; i < this.outputClasses.length; ++i) {
                    outputList.add(this.outputClasses[i]);
                }
                Class[] outputArray = new Class[outputList.size()];
                outputList.toArray(outputArray);
                return outputArray;
            }
            case 2: {
                return this.outputClasses;
            }
        }
        return null;
    }

    public static boolean containsClass(Class<?> c, Class<?>[] oc) {
        for (int i = 0; i < oc.length; ++i) {
            if (!c.isAssignableFrom(oc[i])) continue;
            return true;
        }
        return false;
    }
}

