/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ValueString;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.AttributeSetPrecondition;
import com.rapidminer.operator.ports.metadata.ParameterConditionedPrecondition;
import com.rapidminer.operator.ports.metadata.PassThroughRule;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import com.rapidminer.tools.Ontology;
import com.rapidminer.tools.Tools;
import java.util.List;

public class DataMacroDefinitionOperator
extends Operator {
    private InputPort exampleSetInput = this.getInputPorts().createPort("example set", ExampleSet.class);
    private OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set");
    public static final String PARAMETER_MACRO = "macro";
    public static final String PARAMETER_MACRO_TYPE = "macro_type";
    public static final String PARAMETER_EXAMPLE_INDEX = "example_index";
    public static final String PARAMETER_ATTRIBUTE_NAME = "attribute_name";
    public static final String PARAMETER_ATTRIBUTE_VALUE = "attribute_value";
    public static final String PARAMETER_STATISTICS = "statistics";
    public static final String[] MACRO_TYPES = new String[]{"number_of_examples", "number_of_attributes", "data_value", "statistics"};
    public static final int MACRO_TYPE_EXAMPLES = 0;
    public static final int MACRO_TYPE_ATTRIBUTES = 1;
    public static final int MACRO_TYPE_DATA = 2;
    public static final int MACRO_TYPE_STATISTICS = 3;
    public static final String[] STATISTICS_TYPES = new String[]{"average", "deviation", "variance", "min", "max", "count", "unknown"};
    public static final int STATISTICS_TYPE_AVERAGE = 0;
    public static final int STATISTICS_TYPE_DEVIATION = 1;
    public static final int STATISTICS_TYPE_VARIANCE = 2;
    public static final int STATISTICS_TYPE_MIN = 3;
    public static final int STATISTICS_TYPE_MAX = 4;
    public static final int STATISTICS_TYPE_COUNT = 5;
    public static final int STATISTICS_TYPE_UNKNOWN = 6;
    private String macroValue = null;

    public DataMacroDefinitionOperator(OperatorDescription description) {
        super(description);
        this.exampleSetInput.addPrecondition(new ParameterConditionedPrecondition(this.exampleSetInput, new AttributeSetPrecondition(this.exampleSetInput, AttributeSetPrecondition.getAttributesByParameter(this, PARAMETER_ATTRIBUTE_NAME), new String[0]), this, PARAMETER_MACRO_TYPE, MACRO_TYPES[2]));
        this.getTransformer().addRule(new PassThroughRule(this.exampleSetInput, this.exampleSetOutput, false));
        this.addValue(new ValueString("macro_name", "The name of the macro."){

            @Override
            public String getStringValue() {
                try {
                    return DataMacroDefinitionOperator.this.getParameterAsString(DataMacroDefinitionOperator.PARAMETER_MACRO);
                }
                catch (UndefinedParameterError e) {
                    return null;
                }
            }
        });
        this.addValue(new ValueString("macro_value", "The value of the macro."){

            @Override
            public String getStringValue() {
                return DataMacroDefinitionOperator.this.macroValue;
            }
        });
    }

    @Override
    public void doWork() throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)this.exampleSetInput.getData();
        String macroName = this.getParameterAsString(PARAMETER_MACRO);
        this.macroValue = null;
        int macroType = this.getParameterAsInt(PARAMETER_MACRO_TYPE);
        block0 : switch (macroType) {
            case 1: {
                this.macroValue = exampleSet.getAttributes().size() + "";
                break;
            }
            case 0: {
                this.macroValue = exampleSet.size() + "";
                break;
            }
            case 2: {
                int exampleIndex = this.getParameterAsInt(PARAMETER_EXAMPLE_INDEX);
                if (exampleIndex == 0) {
                    throw new UserError((Operator)this, 207, "0", PARAMETER_EXAMPLE_INDEX, "only positive or negative indices are allowed");
                }
                exampleIndex = exampleIndex < 0 ? exampleSet.size() + exampleIndex : --exampleIndex;
                if (exampleIndex >= exampleSet.size()) {
                    throw new UserError((Operator)this, 110, exampleIndex + 1);
                }
                Attribute attribute = exampleSet.getAttributes().get(this.getParameter(PARAMETER_ATTRIBUTE_NAME));
                if (attribute == null) {
                    throw new UserError((Operator)this, 111, this.getParameterAsString(PARAMETER_ATTRIBUTE_NAME));
                }
                Example example = exampleSet.getExample(exampleIndex);
                if (attribute.isNumerical()) {
                    this.macroValue = Tools.formatIntegerIfPossible(example.getValue(attribute));
                    break;
                }
                this.macroValue = example.getValueAsString(attribute);
                break;
            }
            case 3: {
                Attribute attribute = exampleSet.getAttributes().get(this.getParameter(PARAMETER_ATTRIBUTE_NAME));
                if (attribute == null) {
                    throw new UserError((Operator)this, 111, this.getParameterAsString(PARAMETER_ATTRIBUTE_NAME));
                }
                exampleSet.recalculateAttributeStatistics(attribute);
                int statisticsType = this.getParameterAsInt(PARAMETER_STATISTICS);
                switch (statisticsType) {
                    case 0: {
                        if (attribute.isNominal()) {
                            this.macroValue = attribute.getMapping().mapIndex((int)exampleSet.getStatistics(attribute, "mode"));
                            break block0;
                        }
                        this.macroValue = exampleSet.getStatistics(attribute, "average") + "";
                        break block0;
                    }
                    case 1: {
                        if (!attribute.isNominal()) {
                            this.macroValue = Math.sqrt(exampleSet.getStatistics(attribute, "variance")) + "";
                            break block0;
                        }
                        throw new UserError((Operator)this, 120, attribute.getName(), Ontology.VALUE_TYPE_NAMES[attribute.getValueType()], Ontology.VALUE_TYPE_NAMES[2]);
                    }
                    case 2: {
                        if (!attribute.isNominal()) {
                            this.macroValue = exampleSet.getStatistics(attribute, "variance") + "";
                            break block0;
                        }
                        throw new UserError((Operator)this, 120, attribute.getName(), Ontology.VALUE_TYPE_NAMES[attribute.getValueType()], Ontology.VALUE_TYPE_NAMES[2]);
                    }
                    case 4: {
                        if (attribute.isNominal()) {
                            this.macroValue = attribute.getMapping().mapIndex((int)exampleSet.getStatistics(attribute, "maximum"));
                            break block0;
                        }
                        this.macroValue = exampleSet.getStatistics(attribute, "maximum") + "";
                        break block0;
                    }
                    case 3: {
                        if (attribute.isNominal()) {
                            this.macroValue = attribute.getMapping().mapIndex((int)exampleSet.getStatistics(attribute, "minimum"));
                            break block0;
                        }
                        this.macroValue = exampleSet.getStatistics(attribute, "minimum") + "";
                        break block0;
                    }
                    case 5: {
                        if (attribute.isNominal()) {
                            String attributeValue = this.getParameterAsString(PARAMETER_ATTRIBUTE_VALUE);
                            int index = attribute.getMapping().getIndex(attributeValue);
                            if (index < 0) {
                                throw new UserError((Operator)this, 143, attributeValue, attribute.getName());
                            }
                            this.macroValue = (int)exampleSet.getStatistics(attribute, "count", attributeValue) + "";
                            break block0;
                        }
                        throw new UserError((Operator)this, 119, attribute.getName(), this.getName());
                    }
                    case 6: {
                        this.macroValue = exampleSet.getStatistics(attribute, "unknown") + "";
                    }
                }
            }
        }
        this.getProcess().getMacroHandler().addMacro(macroName, this.macroValue);
        this.exampleSetOutput.deliver(exampleSet);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeString(PARAMETER_MACRO, "The macro name defined by the user.", false, false));
        ParameterTypeSingle type = new ParameterTypeCategory(PARAMETER_MACRO_TYPE, "Indicates the way how the macro should be defined.", MACRO_TYPES, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeCategory(PARAMETER_STATISTICS, "The statistics of the specified attribute which should be used as macro value.", STATISTICS_TYPES, 0);
        type.setExpert(false);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_MACRO_TYPE, MACRO_TYPES, true, 3));
        types.add(type);
        type = new ParameterTypeAttribute(PARAMETER_ATTRIBUTE_NAME, "The name of the attribute from which the data should be derived.", this.exampleSetInput);
        type.setExpert(false);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_MACRO_TYPE, MACRO_TYPES, true, 2, 3));
        types.add(type);
        type = new ParameterTypeString(PARAMETER_ATTRIBUTE_VALUE, "The value of the attribute which should be counted.", true);
        type.setExpert(false);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_MACRO_TYPE, MACRO_TYPES, true, 3));
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_STATISTICS, STATISTICS_TYPES, true, 5));
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_EXAMPLE_INDEX, "The index of the example from which the data should be derived. Negative indices are counted from the end of the data set. Positive counting starts with 1, negative counting with -1.", -2147483647, Integer.MAX_VALUE, true);
        type.setExpert(false);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_MACRO_TYPE, MACRO_TYPES, true, 2));
        types.add(type);
        return types;
    }
}

