/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.DummyPortPairExtender;
import com.rapidminer.operator.ports.PortPairExtender;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.tools.Tools;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;

public class CommandLineOperator
extends Operator {
    public static final String PARAMETER_COMMAND = "command";
    public static final String PARAMETER_LOG_STDOUT = "log_stdout";
    public static final String PARAMETER_LOG_STDERR = "log_stderr";
    private PortPairExtender dummyPorts = new DummyPortPairExtender("through", this.getInputPorts(), this.getOutputPorts());

    public CommandLineOperator(OperatorDescription description) {
        super(description);
        this.dummyPorts.start();
        this.getTransformer().addRule(this.dummyPorts.makePassThroughRule());
    }

    @Override
    public void doWork() throws OperatorException {
        String command = this.getParameterAsString(PARAMETER_COMMAND);
        boolean logOut = this.getParameterAsBoolean(PARAMETER_LOG_STDOUT);
        boolean logErr = this.getParameterAsBoolean(PARAMETER_LOG_STDERR);
        try {
            Process process = Runtime.getRuntime().exec(command);
            if (logErr) {
                this.logOutput("stderr:", process.getErrorStream());
            }
            if (logOut) {
                this.logOutput("stdout:", process.getInputStream());
            }
            Tools.waitForProcess(this, process, command);
            this.getLogger().info("Program exited succesfully.");
        }
        catch (IOException e) {
            throw new UserError((Operator)this, (Throwable)e, 310, command, e.getMessage());
        }
        this.dummyPorts.passDataThrough();
    }

    private void logOutput(String message, InputStream in) throws IOException {
        BufferedReader bin = new BufferedReader(new InputStreamReader(in));
        String line = null;
        StringBuffer buffer = new StringBuffer(message);
        while ((line = bin.readLine()) != null) {
            buffer.append(Tools.getLineSeparator());
            buffer.append(line);
        }
        this.logNote(buffer.toString());
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeString(PARAMETER_COMMAND, "Command to execute.", false, false));
        types.add(new ParameterTypeBoolean(PARAMETER_LOG_STDOUT, "If set to true, the stdout stream of the command is redirected to the logfile.", true));
        types.add(new ParameterTypeBoolean(PARAMETER_LOG_STDERR, "If set to true, the stderr stream of the command is redirected to the logfile.", true));
        return types;
    }
}

