/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Annotations
implements Serializable,
Map<String, String> {
    private static final long serialVersionUID = 1L;
    public static final String ANNOTATIONS_TAG_NAME = "annotations";
    public static final String KEY_SOURCE = "Source";
    public static final String KEY_COMMENT = "Comment";
    public static final String KEY_UNIT = "Unit";
    public static final String KEY_COLOR_MAP = "Colors";
    public static final String KEY_DC_AUTHOR = "dc.author";
    public static final String KEY_DC_TITLE = "dc.title";
    public static final String KEY_DC_SUBJECT = "dc.subject";
    public static final String KEY_DC_COVERAGE = "dc.coverage";
    public static final String KEY_DC_DESCRIPTION = "dc.description";
    public static final String KEY_DC_CREATOR = "dc.creator";
    public static final String KEY_DC_PUBLISHER = "dc.publisher";
    public static final String KEY_DC_CONTRIBUTOR = "dc.contributor";
    public static final String KEY_DC_RIGHTS_HOLDER = "dc.rightsHolder";
    public static final String KEY_DC_RIGHTS = "dc.rights";
    public static final String KEY_DC_PROVENANCE = "dc.provenance";
    public static final String KEY_DC_SOURCE = "dc.source";
    public static final String KEY_DC_RELATION = "dc.relation";
    public static final String KEY_DC_AUDIENCE = "dc.audience";
    public static final String KEY_DC_INSTRUCTIONAL_METHOD = "dc.description";
    public static final String[] KEYS_RAPIDMINER_IOOBJECT = new String[]{"Source", "Comment"};
    public static final String[] KEYS_DUBLIN_CORE = new String[]{"dc.author", "dc.title", "dc.subject", "dc.coverage", "dc.description", "dc.creator", "dc.publisher", "dc.contributor", "dc.rightsHolder", "dc.rights", "dc.provenance", "dc.source", "dc.relation", "dc.audience", "dc.description"};
    public static final String[] ALL_KEYS_IOOBJECT = new String[]{"Source", "Comment", "dc.author", "dc.title", "dc.subject", "dc.coverage", "dc.description", "dc.creator", "dc.publisher", "dc.contributor", "dc.rightsHolder", "dc.rights", "dc.provenance", "dc.source", "dc.relation", "dc.audience", "dc.description"};
    public static final String[] ALL_KEYS_ATTRIBUTE = new String[]{"Comment", "Unit"};
    private LinkedHashMap<String, String> keyValueMap = new LinkedHashMap();
    public static final String ANNOTATION_NAME = "Name";

    public Annotations() {
    }

    public Annotations(Annotations annotations) {
        this.keyValueMap = new LinkedHashMap<String, String>(annotations.keyValueMap);
    }

    public void setAnnotation(String key, String value) {
        this.keyValueMap.put(key, value);
    }

    public String getAnnotation(String key) {
        return this.keyValueMap.get(key);
    }

    public List<String> getKeys() {
        return new ArrayList<String>(this.keyValueMap.keySet());
    }

    public void removeAnnotation(String key) {
        this.keyValueMap.remove(key);
    }

    @Override
    public int size() {
        return this.keyValueMap.size();
    }

    @Override
    public void clear() {
        this.keyValueMap.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keyValueMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.keyValueMap.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.keyValueMap.entrySet();
    }

    @Override
    public String get(Object key) {
        if (key instanceof String) {
            return this.getAnnotation((String)key);
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.keyValueMap.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.keyValueMap.keySet();
    }

    @Override
    public String put(String key, String value) {
        this.setAnnotation(key, value);
        return value;
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        this.keyValueMap.putAll(m);
    }

    @Override
    public String remove(Object key) {
        return (String)this.keyValueMap.remove(key);
    }

    @Override
    public Collection<String> values() {
        return this.keyValueMap.values();
    }

    public String toString() {
        return this.keyValueMap.toString();
    }

    public Element toXML(Document doc) {
        Element elem = doc.createElement(ANNOTATIONS_TAG_NAME);
        for (Map.Entry<String, String> entry : this.keyValueMap.entrySet()) {
            Annotations.addAnnotationToXML(elem, entry.getKey(), entry.getValue());
        }
        return elem;
    }

    public static void addAnnotationToXML(Element annotationsElement, String name, String value) {
        if (value == null) {
            Annotations.deleteAnnotationFromXML(annotationsElement, name);
        } else {
            Document doc = annotationsElement.getOwnerDocument();
            Element elem = doc.createElement("annotation");
            annotationsElement.appendChild(elem);
            elem.setAttribute("key", name);
            elem.setTextContent(value);
        }
    }

    public static void deleteAnnotationFromXML(Element annotationsElement, String name) {
        NodeList children = annotationsElement.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!(child instanceof Element) || !name.equals(((Element)child).getAttribute("annotation"))) continue;
            annotationsElement.removeChild(child);
        }
    }

    public void parseXML(Element annotationsElem) {
        NodeList children = annotationsElem.getElementsByTagName("annotation");
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!(child instanceof Element)) continue;
            String name = ((Element)child).getAttribute("key");
            this.setAnnotation(name, child.getTextContent());
        }
    }

    public List<String> getDefinedAnnotationNames() {
        LinkedList<String> result = new LinkedList<String>();
        result.addAll(this.keySet());
        return result;
    }
}

