/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.ProcessingStep;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.LoggingHandler;
import com.rapidminer.tools.XMLSerialization;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.GZIPInputStream;

public abstract class AbstractIOObject
implements IOObject {
    private static final long serialVersionUID = 7131412868947165460L;
    private String source = null;
    private transient LoggingHandler loggingHandler;
    private transient LinkedList<ProcessingStep> processingHistory = new LinkedList();

    @Override
    public void setSource(String sourceName) {
        this.source = sourceName;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public void appendOperatorToHistory(Operator operator, OutputPort port) {
        if (this.processingHistory == null) {
            this.processingHistory = new LinkedList();
            if (operator.getProcess() != null) {
                this.processingHistory.add(new ProcessingStep(operator, port));
            }
        }
        ProcessingStep newStep = new ProcessingStep(operator, port);
        if (operator.getProcess() != null && (this.processingHistory.isEmpty() || !this.processingHistory.getLast().equals(newStep))) {
            this.processingHistory.add(newStep);
        }
    }

    @Override
    public List<ProcessingStep> getProcessingHistory() {
        if (this.processingHistory == null) {
            this.processingHistory = new LinkedList();
        }
        return this.processingHistory;
    }

    @Override
    public LoggingHandler getLog() {
        if (this.loggingHandler != null) {
            return this.loggingHandler;
        }
        return LogService.getGlobal();
    }

    @Override
    public void setLoggingHandler(LoggingHandler loggingHandler) {
        this.loggingHandler = loggingHandler;
    }

    @Override
    public IOObject copy() {
        return this;
    }

    protected void initWriting() {
    }

    @Override
    public final void write(OutputStream out) throws IOException {
        this.initWriting();
        XMLSerialization.getXMLSerialization().writeXML(this, out);
    }

    @Deprecated
    public static IOObject read(InputStream in) throws IOException {
        XMLSerialization serializer = XMLSerialization.getXMLSerialization();
        if (serializer == null) {
            throw new IllegalStateException("XMLSerialization not initialized, please invoke XMLSerialization.init(ClassLoader) before using this method.");
        }
        return (IOObject)serializer.fromXML(in);
    }

    public static IOObject read(final File file) throws IOException {
        return AbstractIOObject.read(new InputStreamProvider(){

            @Override
            public InputStream getInputStream() throws IOException {
                return new FileInputStream(file);
            }
        });
    }

    public static IOObject read(final byte[] buf) throws IOException {
        return AbstractIOObject.read(new InputStreamProvider(){

            @Override
            public InputStream getInputStream() throws IOException {
                return new ByteArrayInputStream(buf);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IOObject read(InputStreamProvider inProvider) throws IOException {
        ObjectInputStream objectIn = null;
        try {
            objectIn = new ObjectInputStream(inProvider.getInputStream());
            IOObject object = (IOObject)objectIn.readObject();
            objectIn.close();
            IOObject iOObject = object;
            return iOObject;
        }
        catch (Exception e) {
            InputStream in = null;
            try {
                in = new GZIPInputStream(inProvider.getInputStream());
            }
            catch (IOException e1) {
                in = inProvider.getInputStream();
            }
            try {
                IOObject iOObject = AbstractIOObject.read(in);
                return iOObject;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e1) {}
                }
            }
        }
        finally {
            if (objectIn != null) {
                try {
                    objectIn.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static interface InputStreamProvider {
        public InputStream getInputStream() throws IOException;
    }
}

