/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.DataRowReader;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.PassThroughRule;
import com.rapidminer.operator.ports.metadata.SimplePrecondition;
import com.rapidminer.operator.preprocessing.MaterializeDataInMemory;
import com.rapidminer.parameter.UndefinedParameterError;

public abstract class AbstractExampleSetProcessing
extends Operator {
    private final InputPort exampleSetInput = (InputPort)this.getInputPorts().createPort("example set input");
    private final OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set output");
    private final OutputPort originalOutput = (OutputPort)this.getOutputPorts().createPort("original");

    public AbstractExampleSetProcessing(OperatorDescription description) {
        super(description);
        this.exampleSetInput.addPrecondition(new SimplePrecondition(this.exampleSetInput, this.getRequiredMetaData()));
        this.getTransformer().addRule(new PassThroughRule(this.exampleSetInput, this.exampleSetOutput, false){

            @Override
            public MetaData modifyMetaData(MetaData metaData) {
                if (metaData instanceof ExampleSetMetaData) {
                    try {
                        return AbstractExampleSetProcessing.this.modifyMetaData((ExampleSetMetaData)metaData);
                    }
                    catch (UndefinedParameterError e) {
                        return metaData;
                    }
                }
                return metaData;
            }
        });
        this.getTransformer().addPassThroughRule(this.exampleSetInput, this.originalOutput);
    }

    protected final InputPort getInputPort() {
        return this.exampleSetInput;
    }

    protected MetaData modifyMetaData(ExampleSetMetaData metaData) throws UndefinedParameterError {
        return metaData;
    }

    protected ExampleSetMetaData getRequiredMetaData() {
        return new ExampleSetMetaData();
    }

    @Override
    public final void doWork() throws OperatorException {
        ExampleSet inputExampleSet = (ExampleSet)this.exampleSetInput.getData();
        ExampleSet applySet = null;
        if (this.originalOutput.isConnected() && this.writesIntoExistingData()) {
            DataRowReader dataRowReader;
            int type = 0;
            if (inputExampleSet.getExampleTable() instanceof MemoryExampleTable && (dataRowReader = inputExampleSet.getExampleTable().getDataRowReader()).hasNext()) {
                type = ((DataRow)dataRowReader.next()).getType();
            }
            if (type >= 0) {
                applySet = MaterializeDataInMemory.materializeExampleSet(inputExampleSet, type);
            }
        }
        if (applySet == null) {
            applySet = (ExampleSet)inputExampleSet.clone();
        }
        ExampleSet result = this.apply(applySet);
        this.originalOutput.deliver(inputExampleSet);
        this.exampleSetOutput.deliver(result);
    }

    public abstract ExampleSet apply(ExampleSet var1) throws OperatorException;

    public abstract boolean writesIntoExistingData();

    @Override
    public boolean shouldAutoConnect(OutputPort port) {
        if (port == this.originalOutput) {
            return this.getParameterAsBoolean("keep_example_set");
        }
        return super.shouldAutoConnect(port);
    }

    public InputPort getExampleSetInputPort() {
        return this.exampleSetInput;
    }

    public OutputPort getExampleSetOutputPort() {
        return this.exampleSetOutput;
    }
}

