/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.io.process.rules;

import com.rapidminer.io.process.XMLImporter;
import com.rapidminer.io.process.rules.AbstractConditionedParseRule;
import com.rapidminer.operator.Operator;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.tools.XMLException;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SwitchListEntriesRule
extends AbstractConditionedParseRule {
    private String parameter;

    public SwitchListEntriesRule(String operatorTypeName, Element element) throws XMLException {
        super(operatorTypeName, element);
        assert (element.getTagName().equals("switchListEntries"));
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Element childElem;
            Node child = children.item(i);
            if (!(child instanceof Element) || !(childElem = (Element)child).getTagName().equals("parameter")) continue;
            this.parameter = childElem.getTextContent();
        }
    }

    @Override
    protected String conditionedApply(Operator operator, String operatorTypeName, XMLImporter importer) {
        String value;
        if (operator.getParameters().isSpecified(this.parameter) && (value = operator.getParameters().getParameterOrNull(this.parameter)) != null) {
            List<String[]> list = ParameterTypeList.transformString2List(value);
            for (String[] pair : list) {
                String first = pair[0];
                pair[0] = pair[1];
                pair[1] = first;
            }
            operator.getParameters().setParameter(this.parameter, ParameterTypeList.transformList2String(list));
            return "Switched sides of the entries of <code>" + this.parameter + "</code> in <var>" + operator.getName() + "</var>.";
        }
        return null;
    }

    public String toString() {
        return "Switch entries of List " + this.operatorTypeName + "." + this.parameter;
    }
}

